$(document).ready(async function () {
  // GRAFICO
  let options = {
    series: [{
      name: "Percentual",
      data: [{}]
    }],
    chart: {
      type: 'bar',
      height: 300
    },
    tooltip: {
      x: {
        formatter: function (val) {
          return val;
        }
      }
    },
    xaxis: {
      type: 'category',
      labels: {
        formatter: function (val) {
          return val.split(' - ')[0];
        }
      }
    },
    title: {
      text: 'Top 25 produtos com maior desempenho (%)',
    },
    fill: {
      colors: ['#75BE25']
    }
  };
  // FIM GRAFICO

  let listaOrdenacao = [];

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.desempenhoProduto == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, desempenhoProduto: ['EMPRESA'] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }



  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, desempenhoProduto: novasColunas }))

      $('#tabelaRelDesempenhoProduto').DataTable().columns().visible(true);
      // $('#tabelaRelDesempenhoProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaRelDesempenhoProduto').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  adicionarConteudoModal(
    'Desempenho por Produto ou Material', [
    {
      tipo: 'paragrafo',
      valor: 'Este relatório é essencial para a gestão pois demonstra as referências (produtos ou materiais) que tiveram um alto/baixo desempenho de vendas ' +
        'e que consequentemente precisariam ser repostos/retirados da loja.'
    },
    {
      tipo: 'paragrafo',
      valor: 'Tomar o foco maior, com os best sellers da marca (referências de alto desempenho, giro maior de vendas).',
    },
    {
      tipo: 'paragrafo',
      valor: 'Analisar o desempenho de uma referência é essencial para tomada de decisões, de um lado, se teve um bom desempenho é necessário entender ' +
        'a necessidade de repor essa mercadoria na loja para obter um giro maior ainda. Do outro lado, referências que não tiveram um bom desempenho ' +
        'necessitam de uma ação de vendas, como por exemplo, gincana interna, novas fotos do produto para apresenta-lo de uma forma diferente ao consumidor final, ' +
        'campanhas de marketing, para que de fato ele volte a girar e cumprir sua missão que é trazer lucro para a empresa. ' +
        'Dentro do período informado, o relatório resulta tudo o que entrou e saiu, fazendo a relação de desempenho entre ambos.'
    },
    {
      tipo: 'paragrafo',
      valor: 'Importante frisar 2 pontos:'
    },
    {
      tipo: 'lista',
      itens: ['Tudo o que entrou no estoque de uma determinada referência FORA do período informado, não será considerado.']
    },
    {
      tipo: 'paragrafo',
      valor: 'Neste caso, para fazer a análise correta deverá ir ampliando a visão em datas.'
    },
    {
      tipo: 'lista',
      itens: ['Uma referência com baixo desempenho, pode estar refletindo a entrada recente no estoque. Exemplo: 15 dias atrás, entrou 100 peças, foi vendido 10, ' +
        'o desempenho então foi de 10%, porém a referência ainda está dentro de sua vida útil.']
    },
  ]
  );

  const filtroDeposito = await buscaDepositoEmpresaUsuario();

  const utilizaStatus = await CopiaParametro('VENDA', 37) == 1;
  if (utilizaStatus) {
    $('#statusContainer').removeClass('d-none')
  } else {
    $('#statusContainer').addClass('d-none')
  }

  componenteFiltro('material', true);
  componenteFiltro('produto', true);
  componenteFiltro('modelo', true);
  componenteFiltro('colecao', true);
  componenteFiltro('grupoPA', true);
  componenteFiltro('grupoMA', true);
  componenteFiltro('etiqueta', true);
  componenteFiltro('linha', true);
  componenteFiltro('marca', true);
  componenteFiltro('depositoUsuario', true);
  componenteFiltro('tipoVenda', true);
  componenteFiltro('status', true, true, 'Status', [`TIPO = 'VEN'`]);
  componenteFiltro('categoriaProd', true, true, "CategoriaProd");

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#rdProduto, #rdMaterial').on('change', function () {

    $('#txtProduto').empty().trigger('change');
    $('#txtMaterial').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtModelo').empty().trigger('change');
    $('#txtGrupoPA').empty().trigger('change');
    $('#txtGrupoMA').empty().trigger('change');
    $('#txtEtiqueta').empty().trigger('change');
    $('#txtLinha').empty().trigger('change');
    $('#txtMarca').empty().trigger('change');
    $('#txtDepositoUsuario').empty().trigger('change');

    if ($('#rdMaterial').is(':checked')) {
      $('#inputProduto, #inputModelo, #inputGrupoPA, #inputCategoriaProd').addClass('d-none')
      $('#inputMaterial, #inputGrupoMA').removeClass('d-none')
    }
    else {
      $('#inputProduto, #inputModelo, #inputGrupoPA, #inputCategoriaProd').removeClass('d-none')
      $('#inputMaterial, #inputGrupoMA').addClass('d-none')
    }
  });

  $('#rdVenda, #rdFiscal').on('change', function () {
    $('#txtStatus').empty().trigger('change');

    if ($('#rdVenda').is(':checked') && utilizaStatus) {
      $('#statusContainer').removeClass('d-none')
    } else {
      $('#statusContainer').addClass('d-none')
    }
  });

  preencheOrdenacaoTela('DesempenhoProduto');

  limparFiltros(true);

  retornaHintRelatorio('btnImprimir', 'DesempenhoProdResumido')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/desempenhoproduto?`;
        let params;
        const filtros = await retornaFiltros();

        if (filtros.venda_de == '') {
          msgAlerta('Data não informada ou inválida')
          return;
        }

        const filtrosStatus = `&EMITIDO=${filtros.emitido}&PENDENTE=${filtros.pendente}&AGRUPADO=${filtros.agrupado}&DEVOLVIDO=${filtros.devolvido}&CANCELADO=${filtros.cancelado}`;
        if ($('#rdProduto').prop('checked')) {
          params = `TIPO=${filtros.tipo}&BUSCA=${filtros.busca}&PRODUTO=${filtros.produto}&VENDA_DE=${filtros.venda_de}&VENDA_ATE=${filtros.venda_ate}&GRUPO=${filtros.grupo}&MODELO=${filtros.modelo}&ETIQUETA=${filtros.etiqueta}&LINHA=${filtros.linha}&COLECAO=${filtros.colecao}&EMPRESAS_FILTRO=${filtros.empresas}&DEPOSITO=${filtros.deposito}&MARCA=${filtros.marca}&ORDERBY=${listaOrdenacao}&OPCAORELATORIO=${$('#txtOrdem').val()}${filtrosStatus}&TIPO_VENDA=${filtros.tipovenda}&STATUS=${filtros.status}&DESEMPENHODE=${filtros.desempenhoDe}&DESEMPENHOATE=${filtros.desempenhoAte}&CATEGORIA=${filtros.categoria}`;
        } else {
          params = `TIPO=${filtros.tipo}&BUSCA=${filtros.busca}&MATERIAL=${filtros.material}&VENDA_DE=${filtros.venda_de}&VENDA_ATE=${filtros.venda_ate}&GRUPO=${filtros.grupo}&ETIQUETA=${filtros.etiqueta}&LINHA=${filtros.linha}&COLECAO=${filtros.colecao}&EMPRESAS_FILTRO=${filtros.empresas}&DEPOSITO=${filtros.deposito}&MARCA=${filtros.marca}&ORDERBY=${listaOrdenacao}&OPCAORELATORIO=${$('#txtOrdem').val()}${filtrosStatus}&TIPO_VENDA=${filtros.tipovenda}&STATUS=${filtros.status}&DESEMPENHODE=${filtros.desempenhoDe}&DESEMPENHOATE=${filtros.desempenhoAte}&CATEGORIA=${filtros.categoria}`;
        }
        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros() {
    let dep = await formataListas($('#txtDepositoUsuario').val().toString());

    if (dep == '') {
      dep = filtroDeposito;
    }

    const filtros = {
      tipo: $('#rdProduto').prop('checked') == true ? 'P' : 'M',
      venda_de: $('#txtDataVendasDe').val(),
      venda_ate: $('#txtDataVendasAte').val(),
      colecao: await formataListas($('#txtColecao').val().toString()),
      etiqueta: await formataListas($('#txtEtiqueta').val().toString()),
      produto: await formataListas($('#txtProduto').val().toString()),
      material: await formataListas($('#txtMaterial').val().toString()),
      grupo: $('#rdProduto').prop('checked') == true ? await formataListas($('#txtGrupoPA').val().toString()) : await formataListas($('#txtGrupoMA').val().toString()),
      grupoma: await formataListas($('#txtGrupoMA').val().toString()),
      linha: await formataListas($('#txtLinha').val().toString()),
      marca: await formataListas($('#txtMarca').val().toString()),
      empresas: $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')],
      modelo: await formataListas($('#txtModelo').val().toString()),
      deposito: dep,
      emitido: $('#cbEmitido').prop('checked'),
      pendente: $('#cbPendente').prop('checked'),
      agrupado: $('#cbAgrupado').prop('checked'),
      devolvido: $('#cbDevolvido').prop('checked'),
      cancelado: $('#cbCancelado').prop('checked'),
      tipovenda: await formataListas($('#txtTipoVenda').val().toString()),
      busca: $('#rdVenda').prop('checked') == true ? 'V' : 'F',
      desempenhoDe: $('#txtDesempenhoDe').val(),
      desempenhoAte: $('#txtDesempenhoAte').val(),
      categoria: await formataListas($('#txtCategoriaProd').val().toString()),
      status: await formataListas($('#txtStatus').val().toString())
    }

    return filtros;
  };

  function montaComandosCampos() {
    return 'dados = dados.map((key) => { \n' +
      `let mediaDesempenhoProduto = key.DESEMPENHO \n` +
      `if ((mediaDesempenhoProduto == Infinity) || (isNaN(mediaDesempenhoProduto))) { \n` +
      `mediaDesempenhoProduto = 0 \n` +
      `};` +
      'return { ...key, DESEMPENHO: String(TruncaDecimaisNova(2, mediaDesempenhoProduto)) + `%` } \n' +
      '}) \n' +
      ' \n';
  };

  $('#btnConsultar').on('click', async function () {
    // $('#tabelaRelDesempenhoProduto').DataTable().clear();
    Graficos.limpaGrafico(['graficoRelDesempenhoProduto']);
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
    }
    try {
      $.LoadingOverlay('show');
      try {
        let dataSetCols = [];
        listaOrdenacao = [];
        const url = '/sisplan/impressao/v1/desempenhoproduto?';
        const filtros = await retornaFiltros();
        if (filtros.venda_de == '') {
          msgAlerta('Data não informada ou inválida')
          return;
        }

        const params = `TIPO=${filtros.tipo}&` +
          `BUSCA=${filtros.busca}&` +
          `VENDA_DE=${filtros.venda_de}&` +
          `VENDA_ATE=${filtros.venda_ate}&` +
          `PRODUTO=${filtros.produto}&` +
          `MATERIAL=${filtros.material}&` +
          `GRUPO=${filtros.grupo}&` +
          `ETIQUETA=${filtros.etiqueta}&` +
          `LINHA=${filtros.linha}&` +
          `COLECAO=${filtros.colecao}&` +
          `EMPRESAS_FILTRO=${filtros.empresas}&` +
          `MODELO=${filtros.modelo}&` +
          `DEPOSITO=${filtros.deposito}&` +
          `MARCA=${filtros.marca}&` +
          `EMITIDO=${filtros.emitido}&` +
          `PENDENTE=${filtros.pendente}&` +
          `AGRUPADO=${filtros.agrupado}&` +
          `DEVOLVIDO=${filtros.devolvido}&` +
          `CANCELADO=${filtros.cancelado}&` +
          `TIPO_VENDA=${filtros.tipovenda}&` +
          `STATUS=${filtros.status}&` +
          `CATEGORIA=${filtros.categoria}&` +
          `DESEMPENHODE=${filtros.desempenhoDe}&` +
          `DESEMPENHOATE=${filtros.desempenhoAte}`;

        const response = await requisicao('GET', url, params, null, 150000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          if ($.fn.DataTable.isDataTable('#tabelaRelDesempenhoProduto')) {
            $('#tabelaRelDesempenhoProduto').DataTable().destroy();
            $('#tabelaRelDesempenhoProduto').empty();
          }
          $('#chart').empty();
          $('#chart').addClass('d-none');
          return
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        const keys = jsonStr.map((key) => {

          let mediaDesempenhoProduto = key.DESEMPENHO;

          if ((mediaDesempenhoProduto == Infinity) || (isNaN(mediaDesempenhoProduto))) {
            mediaDesempenhoProduto = 0
          };

          return {
            ...key, DESEMPENHO: String(TruncaDecimaisNova(2, mediaDesempenhoProduto)) + '%'
          }
        });

        Object.keys(jsonStr[0]).forEach(k => {
          k = { data: k, title: k }

          switch (k.data) {
            case 'QUANTIDADE_VENDIDA':
              k.title = 'VENDAS'
              break;
            case 'SELL_IN':
              k.title = 'SELL_IN_HIST'
              break;
            default:
              break;
          }

          // if (k.data != 'EMPRESA') {
          dataSetCols.push({
            'title': k.title,
            'data': k.data
          });
          // }

        });

        $('#tabelaRelDesempenhoProduto').DataTable({
          order: [],
          sort: true,
          destroy: true,
          autoWidth: true,
          "colReorder": true,
          "data": keys,
          "columns": dataSetCols,
          columnDefs: [
            {
              "targets": [6, 7, 8, 9],
              "className": 'pr-4 text-right'
            }
          ]
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $($('#tabelaRelDesempenhoProduto').find('th')[6]).prop('title', 'Quantidade Compra')
        $($('#tabelaRelDesempenhoProduto').find('th')[7]).prop('title', 'Quantidade Vendida')
        $($('#tabelaRelDesempenhoProduto').find('th')[9]).prop('title', '(Vendas / Sell In Hist)  * 100')

        // adiciona o botão na tabela e adiciona a função de abrir o modal
        $('#tabelaRelDesempenhoProduto_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelDesempenhoProduto_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/desempenhoproduto?';
          const filtros = await retornaFiltros();
          const filtrosStatus = `&EMITIDO=${filtros.emitido}&PENDENTE=${filtros.pendente}&AGRUPADO=${filtros.agrupado}&DEVOLVIDO=${filtros.devolvido}&CANCELADO=${filtros.cancelado}`;
          const params = `TIPO=${filtros.tipo}&BUSCA=${filtros.busca}&VENDA_ATE=${filtros.venda_ate}&VENDA_DE=${filtros.venda_de}&GRUPO=${filtros.grupo}&ETIQUETA=${filtros.etiqueta}&LINHA=${filtros.linha}&COLECAO=${filtros.colecao}&EMPRESAS_FILTRO=${filtros.empresas}&ORDERBY=${listaOrdenacao}&DEPOSITO=${filtros.deposito}&MARCA=${filtros.marca}${filtrosStatus}&TIPO_VENDA=${filtros.tipovenda}&STATUS=${filtros.status}&DESEMPENHODE=${filtros.desempenhoDe}&DESEMPENHOATE=${filtros.desempenhoAte}&CATEGORIA=${filtros.categoria}`;

          await exportaCSV(url, params, false, null, 'Relatório de Desempenho de Produto', '#tabelaRelDesempenhoProduto', montaComandosCampos());
        })

        $('#tabelaRelDesempenhoProduto').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.desempenhoProduto).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          });

        $('#tabelaRelDesempenhoProduto th').on('click', function () {
          listaOrdenacao = adicionaOrdenacao(
            retornaDataSrcColuna($('#tabelaRelDesempenhoProduto'), $(this)),
            listaOrdenacao
          );
        });

        const dados = $('#tabelaRelDesempenhoProduto').DataTable().data().toArray();

        dados.forEach(obj => {
          obj.DESEMPENHO = parseFloat(obj.DESEMPENHO.replace('%', ''));
        });

        Graficos.criarGrafico({
          container: 'graficoRelDesempenhoProduto',
          tipo: 'column',
          dados: dados,
          nomeSerie: 'Desempenho',
          colunasAgrupamento: ['CODIGO'],
          colunasValor: ['DESEMPENHO'],
          title: 'Top 25 produtos com maior desempenho (%)',
          formatarValor: (value) => {
            return value;
          }
        })
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelDesempenhoProduto').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.desempenhoProduto ?? ['EMPRESA'])
  })

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros padrões da tela.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para Imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaRelDesempenhoProduto',
      popover: {
        title: 'Tabela',
        description: 'Aqui estão os dados dos produtos Filtrados.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});