$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    if (pegaChave('#txtNumero') == '') {
                        insereValor('#txtNumero', ' ', ' ')
                    };
                    if (pegaChave('#txtCliente') == '') {
                        insereValor('#txtCliente', ' ', ' ')
                    };
                    if (pegaChave('#txtFuncionario') == '') {
                        insereValor('#txtFuncionario', ' ', ' ')
                    };
                    if (pegaChave('#txtVendedor') == '') {
                        insereValor('#txtVendedor', ' ', ' ')
                    };
                    if (pegaChave('#txtTabelaPreco') == '') {
                        insereValor('#txtTabelaPreco', ' ', ' ')
                    };

                    $('#avancar1').trigger('click');
                }
                else if ((Element.node.id == 'avancarPagamento')) {
                    $('#avancarPagamento').trigger('click');
                }
                else if ((Element.node.id == 'gravar')) {
                    $('.driver-next-btn').on('click', location.reload());
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'voltarAcesso') {
                    $('#voltarAcesso').trigger('click');
                }
                else if (Element.node.id == 'voltarComercial') {
                    $('#voltarComercial').trigger('click');
                }
                else if (Element.node.id == 'ultimoVoltar') {
                    $('#ultimoVoltar').trigger('click');
                }
                else if (Element.node.id == 'voltarFinanceiro') {
                    $('#voltarFinanceiro').trigger('click');
                }
            }
        });

        driver.defineSteps([{
            element: '#tourGeral',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os dados gerais do orcamento.',
                position: 'top'
            }
        },
        {
            element: '#txtCliente',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtFuncionario',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para avançar para a aba Itens.',
                position: 'left'
            }
        },
        {
            element: '#ultimoVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a aba Geral.',
                position: 'left'
            }
        },
        {
            element: '#avancarItens',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para avançar para a aba Itens.',
                position: 'left'
            }
        },
        {
            element: '#ultimoVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a aba Itens.',
                position: 'left'
            }
        },
        {
            element: '#tabelaItens_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os itens do pedido.',
                position: 'top'
            }
        },
        {
            element: '#btnAdicionar',
            popover: {
                title: 'Botão Adicionar',
                description: 'Clique aqui para inserir itens.',
                position: 'top'
            }
        },
        {
            element: '#avancarPagamento',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para avançar para a aba Pagamento.',
                position: 'top'
            }
        },
        {
            element: '#voltarItens',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a aba Itens.',
                position: 'left'
            }
        },
        {
            element: '#tourFinanceiro',
            popover: {
                title: 'Pagamento',
                description: 'Aqui estão os dados de pagamento.',
                position: 'top'
            }
        },
        {
            element: '#txtCondPagto1',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtMoeda',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o orcamento.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let orcamento = parametros[parametros.length - 1];
    const usaPrecoCorTam = await CopiaParametro("VENDA", 5) == 1
    let currentFs, nextFs, previousFs, opacity;
    let itensAlteracao = []
    adicionaPaginacao();
    adicionaValidacoes();
    aplicaMascara();
    adicionaPesquisaAutocompleta();
    criaTabelas()
    const dataAtual = retornaDataAtual();
    $('#dtEmissao').val(dataAtual);
    $('#txtNumero').focus();

    $('#voltarAcesso').on('click', async function () {
        await deletaRegistro('ORCAMENTOSIMPLES', getCookie('usuario'), orcamento);
        window.location.href = `${BASE_URI}/orcamentosimples`;
    });

    const retornaBotaoOpcoes = () => {
        return '<div class="p-0 d-flex"> ' +
            '     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar" style="background-color:var(--blue); padding: 5px 1px 5px 6px;"><span class="fas fa-edit" style="color:white !important"></span></button>  ' +
            '     <button class="divBtnItens botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir" style="padding: 5px 2px 5px 4px;"><span class="fas fa-trash-alt" style="color:white !important"></span></button>  ' +
            '   </div>';
    };

    if (orcamento != '' && orcamento != 'create') {
        if (await liberarRegistro('ORCAMENTOSIMPLES', orcamento) == false) {
            window.location.href = '../orcamentosimples';
        } else {
            try {
                $.LoadingOverlay("show");
                const url = "/sisplan/orcamento/v1/orcamentosimples?"
                const response = await requisicao('GET', url, `ORCAMENTO=${orcamento}`, null, 360000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if (response.status != 200) {
                    throw msgAlerta(jsonStr.mensagem);
                }

                if (jsonStr && jsonStr.length > 0) {
                    await preencheDadosOrcamento(jsonStr[0])
                    await preencheItensOrcamento(jsonStr)
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados do orçamento: ${error}`);
            } finally {
                $('#txtorcamento').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    } else {
        await carregaValoresPadroes();
    }

    $('#rdSumDiasCorridos, #rdSumDiasUteis').on('change', function () {
        const dias = pegaValor('#txtDias');

        if (dias == '') {
            return;
        }

        if ($('#rdSumDiasCorridos').is(':checked')) {
            consideraDiasCorridos(dias)
        }

        if ($('#rdSumDiasUteis').is(':checked')) {
            consideraDiasUteis(dias)
        }
    })

    $('#txtDias').on('blur', function () {
        const dias = pegaValor('#txtDias');

        if (dias == '') {
            return;
        }

        if ($('#rdSumDiasCorridos').is(':checked')) {
            consideraDiasCorridos(dias)
        }

        if ($('#rdSumDiasUteis').is(':checked')) {
            consideraDiasUteis(dias)
        }
    });

    function consideraDiasCorridos(dias) {
        setarDataAtual('dtValidade', false, parseFloat(dias));
    }

    function consideraDiasUteis(dias) {
        var dataInicial = new Date();

        var data = new Date(dataInicial);

        var contadorDias = 0;
        while (contadorDias < dias) {
            data.setDate(data.getDate() + 1);
            if (data.getDay() !== 0 && data.getDay() !== 6) {
                contadorDias++;
            }
        }

        var ano = data.getFullYear();
        var mes = ("0" + (data.getMonth() + 1)).slice(-2);
        var dia = ("0" + data.getDate()).slice(-2);
        var dataFinalFormatada = ano + "-" + mes + "-" + dia;

        $("#dtValidade").val(dataFinalFormatada);
    }

    function tabelaPrecoManual() {
        $('#txtTabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
        $('#txtTabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
        $('#btn-limpa-TabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
        $('#btn-limpa-TabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
        $('#btn-TabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
        $('#btn-TabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
        if ($('#checkPrecoManual').prop('checked')) {
            insereValor('#txtTabelaPreco', '999', 'Manual');
        } else {
            $('#txtTabelaPreco').val('');
        }
    }

    $('#checkPrecoManual').on('click', function () {
        tabelaPrecoManual()
    });

    $('#btnAdicionar').on('click', function () {
        $('#modalItem').modal('show');
        $('#tabelaGrade').DataTable().columns.adjust().draw(false);
    });

    $('#txtCliente').on('focusout', async function () {
        $.LoadingOverlay('show')
        try {
            if ($(window.location.href.split('/')).get(-1) != 'create') {
                return;
            }
            const cliente = pegaChave('#txtCliente');
            if (cliente == '') {
                return;
            }
            await buscaDadosCliente(cliente);
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    async function buscaDadosCliente(sCliente) {
        const dadosSelect = {
            tabela: 'ENTIDADE',
            camposSelect: ['ENTIDADE.CLASSE', 'ENTIDADE.TABELA', 'ENTIDADE.CODREP', 'REGIAO.DESCRICAO DESC_TABELA', 'REPRESEN.NOME NOME_REP'],
            leftJoin: [
                { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = ENTIDADE.CODREP' },
                { tabela: 'REGIAO', condicao: 'REGIAO.REGIAO = ENTIDADE.TABELA' }
            ],
            where: [`ENTIDADE.CODCLI = '${sCliente}'`]
        };
        const dados = (await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect)))[0];

        insereValor('#txtVendedor', dados.CODREP, dados.NOME_REP);
        insereValor('#txtTabelaPreco', dados.TABELA, dados.DESC_TABELA);

        $('#txtVendedor').trigger('focusout');
    };

    $('#txtVendedor').on('focusout', async function () {
        let represen = pegaChave('#txtVendedor')
        if (!represen) {
            return;
        }
        let regiao = ''

        if (represen) {
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"REPRESEN", 
            "camposSelect":["REGIAO, COMISSAO, COMISSAO2"], 
            "where": ["CODREP = '${represen}'"]}`, null);

            let jsonRepresen = await response.json();

            regiao = jsonRepresen.RESULT[0][0].REGIAO
            $('#txtComFat').val(jsonRepresen.RESULT[0][0].COMISSAO)
            $('#txtComRec').val(jsonRepresen.RESULT[0][0].COMISSAO2)
        }

        pegaChave('#txtTabelaPreco') == '' ? regiao != '' ? insereValor('#txtTabelaPreco', regiao, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: regiao }) : '' : ''
    })

    $('#txtNumero').on('blur', async function () {
        const sNumero = $('#txtNumero').val();
        if (sNumero == '') {
            $('#txtNumero').val(await RetornaProximo('OS', 'OS', 'NUMERO', 6));
            bloqueiaCampoNumero();
            $('#txtDias').trigger('blur')
        } else if (await validaOrcamentoExistente(sNumero)) {
            window.location.href = sNumero;
        } else {
            msgAlerta('Número de orcamento inexistente, favor verificar.');
            $('#txtNumero').val('');
            $('#txtNumero').focus();
        }
    });

    function bloqueiaCampoNumero() {
        $('#txtNumero').prop('disabled', true);
        $('#txtNumero').prop('readonly', true);
    }

    async function validaOrcamentoExistente(sNumero) {
        const dadosSelect = {
            tabela: 'OS',
            camposSelect: ['NUMERO'],
            where: [`NUMERO = '${sNumero}'`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            return;
        }
        if (retornoSelect.length == 0) {
            return false;
        }
        return true;
    };

    function adicionaPaginacao() {
        $(".next").click(async function () {
            let validator = $("#msform").validate();
            let liberado = true;

            if ($(this).attr("id") == "avancar1") {
                validator.element("#txtNumero");
                validator.element("#txtCliente");
                validator.element("#txtVendedor");
                validator.element("#txtFuncionario");
                validator.element("#rgTransportador");
                validator.element("#dtEmissao");
                validator.element("#dtValidade");
                validator.element("#txtTabelaPreco");
                validator.element("#txtMotivo");
                if (!(validator.element("#txtNumero") &&
                    validator.element("#txtCliente") &&
                    validator.element("#txtVendedor") &&
                    validator.element("#txtFuncionario") &&
                    validator.element("#txtTabelaPreco") &&
                    validator.element("#txtMotivo") &&
                    validator.element("#rgTransportador") &&
                    validator.element("#dtEmissao") &&
                    validator.element("#dtValidade"))) {
                    liberado = false;
                }
            }

            if ($(this).attr("id") == "avancarPagamento") {
                calculaTotais()
            }

            if ($(this).attr("id") == "gravar") {
                validator.element("#txtMoeda");
                validator.element("#txtSituacao");
                validator.element("#txtClasseGer");
                validator.element("#txtHistorico");
                if (!(validator.element("#txtMoeda") &&
                    validator.element("#txtSituacao") &&
                    validator.element("#txtClasseGer") &&
                    validator.element("#txtHistorico"))) {
                    liberado = false;
                }
            }

            $('#tabelaItens').DataTable().columns.adjust().draw(false);
            $('#tabelaGrade').DataTable().columns.adjust().draw(false);

            if (liberado) {
                currentFs = $(this).parent();
                nextFs = $(this).parent().next();
                $("#progressbar li").eq($("fieldset").index(nextFs) - 2).addClass("active");
                nextFs.show();
                currentFs.animate({
                    opacity: 0,
                }, {
                    step(now) {
                        opacity = 1 - now;
                        currentFs.css({
                            display: "none",
                            position: "relative",
                        });
                        nextFs.css({
                            opacity,
                        });
                    },
                    duration: 600,
                });
            }
            $("#tabelaItens").DataTable().columns.adjust().draw(false);
        });

        $(".previous").click(async function () {
            currentFs = $(this).parent();
            previousFs = $(this).parent().prev();

            $("#progressbar li").eq($("fieldset").index(currentFs) - 2).removeClass("active");

            previousFs.show();

            currentFs.animate({
                opacity: 0,
            }, {
                step(now) {
                    opacity = 1 - now;

                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    previousFs.css({
                        opacity,
                    });
                },
                duration: 600,
            });

            $('#tabelaItens').DataTable().columns.adjust().draw(false);
        });
    }

    function adicionaValidacoes() {
        $("#msform").validate({
            debug: false,
            ignore: "",
            rules: {
                txtNumero: {
                    required: true,
                },
                txtCliente: {
                    required: true,
                },
                txtVendedor: {
                    required: true,
                },
                txtFuncionario: {
                    required: true,
                },
                txtTabelaPreco: {
                    required: true,
                },
                txtMotivo: {
                    required: true,
                },
                rgTransportador: {
                    required: true,
                },
                dtEmissao: {
                    required: true,
                },
                dtValidade: {
                    required: true,
                },
                txtMoeda: {
                    required: true,
                },
                txtSituacao: {
                    required: true,
                },
                txtClasseGer: {
                    required: true,
                },
                txtHistorico: {
                    required: true,
                },
            },
            messages: {
                txtNumero: {
                    required: "Informe um número.",
                },
                txtCliente: {
                    required: "Informe um cliente.",
                },
                txtVendedor: {
                    required: "Informe um vendedor.",
                },
                txtFuncionario: {
                    required: "Informe uma funcionario.",
                },
                txtMotivo: {
                    required: "Informe um motivo.",
                },
                rgTransportador: {
                    required: "Informe um transportador.",
                },
                dtEmissao: {
                    required: "Informe uma data de emissão.",
                },
                dtValidade: {
                    required: "Informe uma data de validade.",
                },
                txtTabelaPreco: {
                    required: "Informe uma tabela de preço.",
                },
                txtMoeda: {
                    required: "Informe uma moeda.",
                },
                txtSituacao: {
                    required: "Informe uma situação.",
                },
                txtClasseGer: {
                    required: "Informe uma classe gerencial.",
                },
                txtHistorico: {
                    required: "Informe um histórico.",
                },
            },
            errorElement: "span",
            errorPlacement(error, element) {
                error.addClass("invalid-feedback");
                element.closest(".form-group").append(error);
            },
            highlight(element) {
                $(element).addClass("is-invalid");
            },
            unhighlight(element) {
                $(element).removeClass("is-invalid");
            },
        });
    };

    function calculaTotais() {
        const valFrete = parseFloat($('#txtValorFrete').val()) || 0;
        let qtdeTotal = 0;
        let valorTotalItem = 0;
        let valorLiqItem = 0;
        for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
            const item = $('#tabelaItens').DataTable().data().toArray()[i]
            qtdeTotal += parseInt(item.QTDE)
            valorTotalItem = parseFloat(valorTotalItem) + (parseFloat(item.VALOR) + parseFloat(item.DESCONTO) - parseFloat(item.ACRESCIMO))
            valorLiqItem = parseFloat(valorLiqItem) + (parseFloat(item.VALOR))
        }

        const desc = $('#txtDesconto').val() || 0
        let novoValorLiq = valorLiqItem
        if (desc > 0) {
            novoValorLiq = valorLiqItem - (valorLiqItem * (desc / 100)) || 0
        } else {
            novoValorLiq = valorLiqItem || 0
        }
        const valLiqComFrete = parseFloat(novoValorLiq + valFrete)

        $('#txtTotalQtde').text(qtdeTotal)
        $('#txtValorTotal').html(valorTotalItem.toFixed(2).replace('.', ','));
        $('#txtTotalLiquido').html(novoValorLiq.toFixed(2).replace('.', ','));

        $('#txtValorFreteTotal').html(valFrete.toFixed(2).replace('.', ','));
        $('#txtValorLiqFrete').html(valLiqComFrete.toFixed(2).replace('.', ','));

        $('#txtValorTotalItem').val(valorTotalItem.toFixed(2).replace('.', ','));
        $('#txtValorTotalItens').val(valorLiqItem.toFixed(2).replace('.', ','));
        $('#txtQtdeTotalItens').val(qtdeTotal)
    }

    function criaTabelas() {
        const colunasItens = [
            { title: 'Ordem', data: 'ORDEM' },
            { title: 'Tipo', data: 'TIPO' },
            { title: 'Código', data: 'CODIGO' },
            { title: 'Descrição', data: 'DESCRICAO' },
            { title: 'Compl. Prod', data: 'COMPL_PROD' },
            { title: 'Cor', data: 'COR' },
            { title: 'Desc. Cor', data: 'DESCCOR' },
            { title: 'Tam', data: 'TAM' },
            { title: 'Qtde', data: 'QTDE' },
            { title: 'Preço', data: 'PRECO' },
            { title: 'Desconto', data: 'DESCONTO' },
            { title: 'Acrescimo', data: 'ACRESCIMO' },
            { title: 'Valor', data: 'VALOR' },
            { title: 'Obs', data: 'OBSERVACAO' },
            { title: 'Faixa', data: 'FAIXA' },
            { title: 'Excluir', data: 'EXCLUIR' },
        ];

        const colunasGrade = [
            { title: 'Tamanho', data: 'TAMANHO' },
            { title: 'Qtde', data: 'QTDE' },
            { title: 'Preço', data: 'PRECO' },
            { title: '% Acresc.', data: 'PERC_ACRESC' },
            { title: 'Val Acresc.', data: 'VAL_ACRESC' },
            { title: '% Desc.', data: 'PERC_DESC' },
            { title: 'Val Desc.', data: 'VAL_DESC' },
            { title: 'Preço Líq.', data: 'PRECO_LIQ' },
            { title: 'Total', data: 'TOTAL' },
        ];

        $('#tabelaItens').DataTable({
            destroy: true,
            lengthChange: false,
            autoWidth: true,
            filter: false,
            info: false,
            columns: colunasItens,
            scrollY: '300px',
            scrollX: true,
            columnDefs: [
                {
                    render: function (data, type, row) {
                        return retornaBotaoOpcoes();
                    },
                    targets: [15],
                },
                {
                    visible: false,
                    targets: [10, 11, 13, 14]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-BR", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    targets: [9, 10, 11, 12],
                    className: 'pr-4 text-right'
                }
            ],
        });

        $('#tabelaGrade').DataTable({
            destroy: true,
            lengthChange: false,
            autoWidth: true,
            filter: false,
            info: false,
            paging: false,
            order: false,
            columns: colunasGrade,
            columnDefs: [
                {
                    className: "text-right",
                    render(data) {
                        if (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return parseFloat(0).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        }
                    },
                    targets: [7, 8],
                }
            ],
        });
    }

    function aplicaMascara() {
        $(".camposMascara").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $(".camposMascara").on('blur', function () {
            if (($(this).val() == '0.00') || ($(this).val() == '')) {
                $(this).val('0.00');
            }
        });

        $('.camposMascaraQtde').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        })

        $(".camposMascaraQtde").on('blur', function () {
            if (($(this).val() == '0') || ($(this).val() == '')) {
                $(this).val('0');
            }
        });

        $("#txtDias").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        });

        $('.maskDecimais').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.maskDecimais').on('blur', function () {
            if ($(this).val() == "") {
                $(this).val('0.00');
            }
        });
    };

    function calculaTotaisGrade(sCampo, iIndex) {
        const valor = parseFloat($($('.' + sCampo)[iIndex]).val());
        const qtde = parseInt($($('.txtQtdeGrade')[iIndex]).val());
        const preco = parseFloat($($('.txtPrecoGrade')[iIndex]).val());

        switch (sCampo) {
            case 'txtQtdeGrade': {
                const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
                dados.TOTAL = (preco * valor).toFixed(2);
                dados.PRECO_LIQ = dados.TOTAL;

                if (parseInt($($('.txtQtdeGrade')[iIndex]).val()) > 0) {
                    if (!(itensAlteracao && itensAlteracao.length > 0)) {
                        if ($('#txtMarkup').val() == '') {
                            msgAlerta('Selecione um Markup!')
                            $($('.txtQtdeGrade')[iIndex]).val('0')
                            return;
                        }
                    }
                }

                $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
                $($('.txtPercAcresGrade')[iIndex]).val('0.00');
                $($('.txtValAcresGrade')[iIndex]).val('0.00');
                $($('.txtPercDescGrade')[iIndex]).val('0.00');
                $($('.txtValDescGrade')[iIndex]).val('0.00');
                break;
            }
            case 'txtPrecoGrade': {
                const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
                dados.TOTAL = (preco * qtde).toFixed(2);
                dados.PRECO_LIQ = dados.TOTAL;
                
                $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
                $($('.txtPercAcresGrade')[iIndex]).val('0.00');
                $($('.txtValAcresGrade')[iIndex]).val('0.00');
                $($('.txtPercDescGrade')[iIndex]).val('0.00');
                $($('.txtValDescGrade')[iIndex]).val('0.00');
                break;
            }
            case 'txtPercAcresGrade': {
                const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
                const valorAcres = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
                dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valorAcres).toFixed(2);

                $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
                $($('.txtValAcresGrade')[iIndex]).val(valorAcres.toFixed(2));
                $($('.txtPercDescGrade')[iIndex]).val('0.00');
                $($('.txtValDescGrade')[iIndex]).val('0.00');
                break;
            }
            case 'txtValAcresGrade': {
                const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
                const percAcres = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
                dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valor).toFixed(2);

                $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
                $($('.txtPercAcresGrade')[iIndex]).val(percAcres.toFixed(2));
                $($('.txtPercDescGrade')[iIndex]).val('0.00');
                $($('.txtValDescGrade')[iIndex]).val('0.00');
                break;
            }
            case 'txtPercDescGrade': {
                const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
                const valorDesc = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
                dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valorDesc).toFixed(2);

                $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
                $($('.txtValDescGrade')[iIndex]).val(valorDesc.toFixed(2));
                $($('.txtPercAcresGrade')[iIndex]).val('0.00');
                $($('.txtValAcresGrade')[iIndex]).val('0.00');
                break;
            }
            case 'txtValDescGrade': {
                const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
                const percDesc = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
                dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valor).toFixed(2);

                $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
                $($('.txtPercDescGrade')[iIndex]).val(percDesc.toFixed(2));
                $($('.txtPercAcresGrade')[iIndex]).val('0.00');
                $($('.txtValAcresGrade')[iIndex]).val('0.00');
                break;
            }
        }

        $('.txtCamposGrade').off('blur');

        $('.txtCamposGrade').on('blur', function () {
            calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', '').replace(' camposMascaraQtde', '').replace(' camposMascara', ''), $(this).attr('data-index'));
        });

        aplicaMascara();

        $($('.' + sCampo)[iIndex]).val(valor.toFixed(2));
        $($('.txtQtdeGrade')[iIndex]).val(qtde.toFixed(0));
        $($('.txtPrecoGrade')[iIndex]).val(preco.toFixed(2));

        atualizaTotaisGrade();
    };

    function atualizaTotaisGrade() {
        let qtdeTotal = 0;
        $('.txtQtdeGrade').each(index => { qtdeTotal += parseInt($($('.txtQtdeGrade')[index]).val()) });

        const valTotal = $("#tabelaGrade").DataTable().column(8, {}).data().sum();

        insereValor('#txtQtdeTotal', qtdeTotal.toFixed(2));
        insereValor('#txtValTotal', valTotal.toFixed(2));
    };

    $('.rgTipoItem').on('click', function () {
        if ($(this).is('#rgProduto')) {
            $('#divMaterial').addClass('d-none');
            $('#divProduto').removeClass('d-none');
        } else {
            $('#divMaterial').removeClass('d-none');
            $('#divProduto').addClass('d-none');
        }
    })

    function limpaTabelaGrade() {
        $("#tabelaGrade").DataTable().clear();
        $('#tabelaGrade').DataTable().data().draw(false);

        insereValor('#txtQtdeTotal', 0);
        insereValor('#txtValTotal', 0);
    }

    $('#txtCorMaterial').on('focusout', async function () {
        if (!$(this).val()) {
            return
        }
        await explodeFaixa()
    })

    $('#txtMaterial').on('blur', async function () {
        if (!$(this).val()) {
            limpaTabelaGrade()
            return
        }
        $.LoadingOverlay('show')
        try {
            $('.rgTipoItem').prop('disabled', true);
            const codigo = pegaChave('#txtMaterial');

            $('#txtCorMaterial').off('autocompleta');
            $('#txtCorMaterial').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"] }`, undefined, undefined, undefined, async () => await buscaPrecoMatCor());
            $('#btn-CorMaterial').off();
            $('#btn-CorMaterial').pesquisa_array(['#txtCorMaterial'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"]}`, 'Pesquisa Cor', 'CADCOR', async () => await buscaPrecoMatCor());

            if (itensAlteracao.length <= 0) {
                $('#txtCorMaterial').val('')
                const pesquisaCor = {
                    tabela: "MAT_ITEN",
                    camposSelect: [
                        "MAT_ITEN.COR",
                        "CADCOR.DESCRICAO"
                    ],
                    leftJoin: [{ tabela: "CADCOR", condicao: "MAT_ITEN.COR = CADCOR.COR" }],
                    groupBy: [
                        "MAT_ITEN.COR",
                        "CADCOR.DESCRICAO"
                    ],
                    where: [`MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S'`],
                }
                const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

                if (jsonStrCor && jsonStrCor.length == 1) {
                    insereValor('#txtCorMaterial', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
                    $('#txtCorMaterial').trigger('focusout')
                }
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtCorProduto').on('focusout', async function () {
        if (!$(this).val()) {
            return
        }
        await explodeFaixa(pegaChave('#txtFaixa'))
    });

    $('#txtProduto').on('blur', async function () {
        if (!$(this).val()) {
            limpaTabelaGrade()
            return
        }
        $.LoadingOverlay('show')
        try {
            $('.rgTipoItem').prop('disabled', true);
            const codigo = pegaChave('#txtProduto');
            await preencheFaixa(codigo)

            $('#txtCorProduto').unbind('autocompleta');
            $('#txtCorProduto').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"] }`);
            $('#btn-CorProduto').off();
            $('#btn-CorProduto').unbind();
            $('#btn-CorProduto').pesquisa_array(['#txtCorProduto'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"]}`, 'Pesquisa Cor', 'CADCOR');

            if (itensAlteracao.length <= 0) {
                $('#txtCorProduto').val('')

                const pesquisaCor = {
                    tabela: "PA_ITEN",
                    camposSelect: [
                        "PA_ITEN.COR",
                        "CADCOR.DESCRICAO"
                    ],
                    leftJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }],
                    groupBy: [
                        "PA_ITEN.COR",
                        "CADCOR.DESCRICAO"
                    ],
                    where: [`PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'`],
                }
                const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

                if (jsonStrCor && jsonStrCor.length == 1) {
                    insereValor('#txtCorProduto', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
                    $('#txtCorProduto').trigger('focusout')
                }
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function preencheFaixa(codigo) {
        $.LoadingOverlay('show')
        try {
            const pesquisaParam = {
                tabela: 'PRODUTO',
                camposSelect: ['PRODUTO.FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA'],
                leftJoin: [{ tabela: "FAIXA", condicao: `FAIXA.CODIGO = PRODUTO.FAIXA` }],
                where: [`PRODUTO.CODIGO = '${codigo}'`],
            }

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            if (jsonStr.length > 0) {
                insereValor('#txtFaixa', jsonStr[0].FAIXA, jsonStr[0].DESC_FAIXA);
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function retornaPrecoTabela(codigo, cor, tabela) {
        if (tabela != '999') {
            let pesquisaParam
            if (!usaPrecoCorTam) {
                pesquisaParam = {
                    tabela: 'TABPRECO',
                    camposSelect: ['PRECO_00 AS PRECO'],
                    where: [`REGIAO = '${tabela}' AND CODIGO = '${codigo}'`]
                }
            } else {
                pesquisaParam = {
                    tabela: 'PRECO_COR_TAM',
                    camposSelect: ['PRECO'],
                    where: [`REGIAO = '${tabela}' AND CODIGO = '${codigo}' AND COR = '${cor}'`]
                }
            }

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            return jsonStr[0]?.PRECO;
        }

        return 0;
    }

    async function retornaPrecoProd(codigo, tipo) {
        if (tipo == 'P') {
            const preco = await buscaValor('PRODUTO', 'PRECO', 'CODIGO', codigo);

            return preco?.PRECO;
        } else {
            const preco = await buscaValor('MATERIAL', 'PRECO', 'CODIGO', codigo);

            return preco?.PRECO;
        }
    }

    async function montaPrecoItem() {
        const tipo = $('#rgProduto').is(':checked') ? 'P' : 'M';
        const codigo = tipo == 'P' ? pegaChave('#txtProduto') : pegaChave('#txtMaterial')
        const cor = tipo == 'P' ? pegaChave('#txtCorProduto') : pegaChave('#txtCorMaterial')
        const tabela = pegaChave('#txtTabelaPreco')
        let preco = 0

        preco = await retornaPrecoTabela(codigo, cor, tabela);

        if (preco <= 0) {
            preco = await retornaPrecoProd(codigo, tipo)
        }

        return preco
    }

    function retornaInputValor(sNomeInput, iIndex = 0, valor = 0) {
        return `<input type="text" 
                  class="input-default focus form-control text-right ${sNomeInput}" 
                  data-campo="${sNomeInput}" 
                  data-index="${iIndex}" 
                  value="${valor}">`
    };

    async function explodeFaixa(sFaixa = '') {
        $.LoadingOverlay('show');
        $('#tabelaGrade').DataTable().clear();
        try {
            let jsonStr
            const sTabPreco = pegaChave('#txtTabelaPreco')
            const tipo = $('#rgProduto').is(':checked') ? 'P' : 'M';
            const sCodigo = tipo == 'P' ? pegaChave('#txtProduto') : pegaChave('#txtMaterial')
            const sCor = tipo == 'P' ? pegaChave('#txtCorProduto') : pegaChave('#txtCorMaterial')
            if (sFaixa != '') {
                let pesquisaParam;
                if (!usaPrecoCorTam) {
                    pesquisaParam = {
                        tabela: 'FAIXA_ITEN',
                        camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'TABPRECO.PRECO_00 PRECO'],
                        leftJoin: [{ tabela: "TABPRECO", condicao: `TABPRECO.REGIAO = '${sTabPreco}' AND TABPRECO.CODIGO = '${sCodigo}'` }],
                        where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
                        orderBy: ['FAIXA_ITEN.POSICAO'],
                    }
                } else {
                    pesquisaParam = {
                        tabela: 'FAIXA_ITEN',
                        camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'PRECO_COR_TAM.PRECO'],
                        leftJoin: [{ tabela: "PRECO_COR_TAM", condicao: `PRECO_COR_TAM.REGIAO = '${sTabPreco}' AND PRECO_COR_TAM.CODIGO = '${sCodigo}' AND PRECO_COR_TAM.COR = '${sCor}' AND PRECO_COR_TAM.TAM = FAIXA_ITEN.TAMANHO` }],
                        where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
                        orderBy: ['FAIXA_ITEN.POSICAO'],
                    }
                }

                jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
            } else {
                jsonStr = [{ TAMANHO: '0' }]
            }

            const precoItem = await montaPrecoItem();

            jsonStr.map((item, index) => {
                $('#tabelaGrade').DataTable().row.add({
                    TAMANHO: item.TAMANHO,
                    QTDE: retornaInputValor('txtQtdeGrade camposMascaraQtde txtCamposGrade', index),
                    PRECO: retornaInputValor('txtPrecoGrade camposMascara txtCamposGrade', index, precoItem),
                    PERC_ACRESC: retornaInputValor('txtPercAcresGrade camposMascara txtCamposGrade', index),
                    VAL_ACRESC: retornaInputValor('txtValAcresGrade camposMascara txtCamposGrade', index),
                    PERC_DESC: retornaInputValor('txtPercDescGrade camposMascara txtCamposGrade', index),
                    VAL_DESC: retornaInputValor('txtValDescGrade camposMascara txtCamposGrade', index),
                    PRECO_LIQ: '0.00',
                    TOTAL: '0.00',
                }).draw(false);
            });

            if (itensAlteracao.length > 0) {
                $('#tabelaGrade').DataTable().data().toArray().forEach((item, index) => {
                    const itemAlteracao = itensAlteracao.find(item2 => item2.TAM == item.TAMANHO);
                    const data = item

                    $('#tabelaGrade').DataTable().row(index).data(data).draw(false)
                    if (itemAlteracao) {
                        $($('.txtQtdeGrade')[index]).val(itemAlteracao.QTDE)
                        $($('.txtPrecoGrade')[index]).val(itemAlteracao.PRECO)
                        calculaTotaisGrade($($('.txtQtdeGrade')[index]).attr('data-campo').replace(' txtCamposGrade', '').replace(' camposMascaraQtde', '').replace(' camposMascara', ''), $($('.txtQtdeGrade')[index]).attr('data-index'));
                        if (itemAlteracao.DESCONTO > 0) {
                            $($('.txtValDescGrade')[index]).val(itemAlteracao.DESCONTO)
                            calculaTotaisGrade($($('.txtValDescGrade')[index]).attr('data-campo').replace(' txtCamposGrade', '').replace(' camposMascaraQtde', '').replace(' camposMascara', ''), $($('.txtValDescGrade')[index]).attr('data-index'));
                        }
                        if (itemAlteracao.ACRESCIMO > 0) {
                            $($('.txtValAcresGrade')[index]).val(itemAlteracao.ACRESCIMO)
                            calculaTotaisGrade($($('.txtValAcresGrade')[index]).attr('data-campo').replace(' txtCamposGrade', '').replace(' camposMascaraQtde', '').replace(' camposMascara', ''), $($('.txtValAcresGrade')[index]).attr('data-index'));
                        }
                    } else {
                        $($('.txtQtdeGrade')[index]).val(0)
                        $($('.txtPrecoGrade')[index]).val(precoItem)
                        calculaTotaisGrade($($('.txtQtdeGrade')[index]).attr('data-campo').replace(' txtCamposGrade', '').replace(' camposMascaraQtde', '').replace(' camposMascara', ''), $($('.txtQtdeGrade')[index]).attr('data-index'));
                    }
                })
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $('.txtCamposGrade').on('blur', function () {
                calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', '').replace(' camposMascaraQtde', '').replace(' camposMascara', ''), $(this).attr('data-index'));
            });

            insereValor('#txtQtdeTotal', '0.00');
            insereValor('#txtValTotal', '0.00');

            aplicaMascara();

            $.LoadingOverlay('hide');
        }
    };

    async function limpaValoresItens() {
        limpaValor('#txtCorProduto')
        limpaValor('#txtCorMaterial')
        limpaValor('#txtProduto')
        limpaValor('#txtMaterial')
        limpaValor('#txtComplemento')
        limpaValor('#txtFaixa')
        limpaValor('#txtObs')
        limpaValor('#txtComplemento')
        $('.rgTipoItem').prop('disabled', false);
        $('#rgProduto').prop('checked', true);
        $('#rgProduto').trigger('click');

        limpaTabelaGrade()
        itensAlteracao = []
    }

    $('#btnDesistirItem').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await limpaValoresItens()
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnConfirmarItem').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await preencheItens()
            await limpaValoresItens()
            itensAlteracao = []
            calculaTotais()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaItens').on('click', '#btn-excluir', async function () {
        await msgAguardaConfirmacao('Deseja excluir este registro?', async () => {
            $('#tabelaItens').DataTable().data().rows($('#tabelaItens').DataTable().row($($(this).get(0)).closest('tr')).index()).remove().draw(false);
            calculaTotais()
        })
    })

    $('#modalItem').on('shown.bs.modal', function () {
        atualizaTotaisGrade()
    })

    $('#modalItem').on('hide.bs.modal', function () {
        limpaValoresItens()
    })

    $('#tabelaItens').on('click', '#btn-editar', async function () {
        $.LoadingOverlay('show')
        try {
            const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
            itensAlteracao = $('#tabelaItens').DataTable().data().toArray().filter(item => { return item.CODIGO == data.CODIGO && item.ORDEM == data.ORDEM })
            $('#txtObs').val(data.OBSERVACAO)
            $('#txtComplemento').val(data.COMPL_PROD)

            $('#modalItem').modal('show')

            if (data.TIPO == 'P') {
                insereValor('#txtProduto', data.CODIGO, data.DESCRICAO)
                insereValor('#txtCorProduto', data.COR, data.DESCCOR)
                insereValor('#txtFaixa', data.FAIXA, { tabela: 'FAIXA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.FAIXA })
                await explodeFaixa(data.FAIXA);
                $('.rgTipoItem').prop('disabled', true);
                $('#rgProduto').prop('checked', true);
                $('#rgProduto').trigger('click');

            } else {
                insereValor('#txtMaterial', data.CODIGO, data.DESCRICAO)
                insereValor('#txtCorMaterial', data.COR, data.DESCCOR)
                await explodeFaixa();
                $('.rgTipoItem').prop('disabled', true);
                $('#rgMaterial').prop('checked', true);
                $('#rgMaterial').trigger('click');
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function validacoesPreencheItens(tabelaGrade, cor) {
        let qtdeTotal = 0;
        let existeItemSemValor = false

        for (let i = 0; i < tabelaGrade.length; i++) {
            qtdeTotal += parseInt($($('.txtQtdeGrade')[i]).val())

            if (parseInt($($('.txtQtdeGrade')[i]).val()) > 0 && parseFloat($($('.txtPrecoGrade')[i]).val()) <= 0) {
                existeItemSemValor = true
                break;
            }
        }
        if (cor == '') {
            throw new Error('Cor não informada')
        }
        if (qtdeTotal <= 0) {
            throw new Error('Quantidade da grade não preenchida, verifique.')
        }
        if (existeItemSemValor) {
            throw new Error('Existem itens com quantidade sem preço informado, verifique.')
        }
    }

    async function preencheItens() {
        const tabelaItens = $('#tabelaItens').DataTable()
        const tipo = $('#rgProduto').is(':checked') ? 'P' : 'M'
        let ordem = tabelaItens.data().toArray().length <= 0 ? 0 : tabelaItens.column(0).data().reduce(function (a, b) {
            return Math.max(a, b)
        })
        ordem = itensAlteracao.length > 0 ? parseInt(itensAlteracao[0].ORDEM) <= 0 ? ordem + 1 : itensAlteracao[0].ORDEM : ordem + 1
        const cor = tipo == 'P' ? pegaChave('#txtCorProduto') : pegaChave('#txtCorMaterial');
        const descCor = tipo == 'P' ? pegaDescricao('#txtCorProduto') : pegaDescricao('#txtCorMaterial');
        const codigo = tipo == 'P' ? pegaChave('#txtProduto') : pegaChave('#txtMaterial');
        const descricao = tipo == 'P' ? pegaDescricao('#txtProduto') : pegaDescricao('#txtMaterial');

        const tabelaGrade = $('#tabelaGrade').DataTable().data().toArray()

        validacoesPreencheItens(tabelaGrade, cor)

        for (let i = 0; i < tabelaGrade.length; i++) {
            const grade = tabelaGrade[i]

            const obj = {
                ORDEM: ordem,
                TIPO: tipo,
                CODIGO: codigo,
                DESCRICAO: descricao,
                COMPL_PROD: pegaValor('#txtComplemento'),
                COR: cor,
                DESCCOR: descCor,
                TAM: grade.TAMANHO,
                QTDE: parseInt($($('.txtQtdeGrade')[i]).val()),
                PRECO: parseFloat($($('.txtPrecoGrade')[i]).val()),
                DESCONTO: parseFloat($($('.txtValDescGrade')[i]).val()),
                ACRESCIMO: parseFloat($($('.txtValAcresGrade')[i]).val()),
                VALOR: parseFloat(grade.TOTAL),
                OBSERVACAO: $('#txtObs').val(),
                FAIXA: tipo == 'P' ? pegaChave('#txtFaixa') : '',
            }

            if (itensAlteracao && itensAlteracao.length > 0) {
                const itemExistente = itensAlteracao.find(item =>
                    item.ORDEM == obj.ORDEM &&
                    item.CODIGO == obj.CODIGO &&
                    item.COR == obj.COR &&
                    item.TAM == obj.TAM
                );

                if (itemExistente) {
                    tabelaItens.rows(function (idx, data, node) {
                        return data.ORDEM == obj.ORDEM && data.CODIGO == obj.CODIGO && data.COR == obj.COR && data.TAM == obj.TAM;
                    }).remove().draw(false);
                }
            }


            if (parseInt($($('.txtQtdeGrade')[i]).val()) <= 0) {
                continue
            }

            tabelaItens.row.add(obj).draw(false);
        }
        calculaTotais()
        $('#modalItem').modal('hide')
    }


    $("#txtDesconto1, #txtDesconto2, #txtDesconto3, #txtDesconto4, #txtDesconto5").change(async function () {
        const desc = descontoUnificado('0' + $('#txtDesconto1').val() + '+0' + $('#txtDesconto2').val() + '+0' + $('#txtDesconto3').val() + '+0' + $('#txtDesconto4').val() + '+0' + $('#txtDesconto5').val())
        $('#txtDesconto').val(desc)
        $('#txtDesconto').trigger('change')
    });

    $('#txtDesconto').on('change', function () {
        calculaTotais()
    })

    function descontoUnificado(descontos) {
        let descUni = 100;
        let descRestante = descontos + '+';

        while (descRestante.indexOf('+') > 0 && descRestante.length > 1) {
            let desc = parseFloat($.trim(descRestante.substring(0, descRestante.indexOf('+'))));
            descUni = descUni - ((descUni / 100) * desc);
            descRestante = descRestante.substring(descRestante.indexOf('+') + 1);
        }

        return parseFloat((100 - descUni).toFixed(2));
    }

    function validacoesGravar(validator) {
        if ($('#tabelaItens').DataTable().data().toArray().length <= 0) {
            throw new Error('Orçamento sem itens!');
        }

        if (prazoPedido().trim() == '') {
            throw new Error('Condições de pagamento não informadas!');
        }

        validator.element("#txtMoeda");
        validator.element("#txtSituacao");
        validator.element("#txtClasseGer");
        validator.element("#txtHistorico");
        if (!(validator.element("#txtMoeda") &&
            validator.element("#txtSituacao") &&
            validator.element("#txtClasseGer") &&
            validator.element("#txtHistorico"))) {
            return false;
        }

        return true;
    }

    $("#gravar").on('click', async function () {
        $.LoadingOverlay('show')
        try {
            let validator = $("#msform").validate();
            let liberado = validacoesGravar(validator);

            if (liberado) {
                await gravaDados()
                criaMensagemSucesso('Orçamento gravado com sucesso.', () => { window.location.href = `${BASE_URI}/orcamentosimples`; });
            }

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function junta(texto) {
        while (texto.length < 3) {
            texto = texto + ' '
        }

        return texto;
    }

    function prazoPedido() {
        let prazo = '';
        prazo = prazo + junta($('#txtCondPagto1').val());
        prazo = prazo + junta($('#txtCondPagto2').val());
        prazo = prazo + junta($('#txtCondPagto3').val());
        prazo = prazo + junta($('#txtCondPagto4').val());
        prazo = prazo + junta($('#txtCondPagto5').val());
        prazo = prazo + junta($('#txtCondPagto6').val());
        prazo = prazo + junta($('#txtCondPagto7').val());
        prazo = prazo + junta($('#txtCondPagto8').val());
        prazo = prazo + junta($('#txtCondPagto9').val());
        prazo = prazo + junta($('#txtCondPagto10').val());
        prazo = prazo + junta($('#txtCondPagto11').val());
        prazo = prazo + junta($('#txtCondPagto12').val());

        return prazo;
    }

    function campoDesconto(desc1, desc2, desc3, desc4, desc5) {
        let sDescontos = '';

        function formatDesconto(valor) {
            if (valor > 0) {
                return valor.toFixed(2).padStart(5, ' ');
            } else {
                return ''
            }
        }

        sDescontos += formatDesconto(desc1);
        sDescontos += formatDesconto(desc2);
        sDescontos += formatDesconto(desc3);
        sDescontos += formatDesconto(desc4);
        sDescontos += formatDesconto(desc5);

        return sDescontos;
    }

    async function gravaDados() {

        const prazo = prazoPedido()
        const arrayItens = []
        for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
            const item = $('#tabelaItens').DataTable().data().toArray()[i]

            arrayItens.push({
                ORDEM_DIG: item.ORDEM,
                ORDEM: 1,
                CODIGO: item.CODIGO,
                DESCRICAO: item.DESCRICAO,
                QUALIDADE: '1',
                COR: item.COR,
                TAM: item.TAM,
                QTDE: item.QTDE,
                PRECO: item.PRECO,
                PRECO_LIQ: item.PRECO,
                VALOR_TOTAL: item.VALOR,
                TIPO_PROD: 'E',
                TIPO: item.TIPO,
                OBSERVACAO: item.OBSERVACAO,
                FAIXA: item.FAIXA,
                COMPL_PROD: item.COMPL_PROD,
                ACRESCIMO: item.ACRESCIMO,
                DESCONTO: item.DESCONTO,
                TELA: 'SERVOS2'
            });
        }

        const classOs = {
            USUARIO: getCookie('usuario'),
            NUMERO: pegaValor('#txtNumero'),
            EMP_FAT: getCookie('empresa'),
            CLIENTE: pegaChave('#txtCliente'),
            COD_VEN: pegaChave('#txtVendedor'),
            FUNCIONARIO: pegaChave('#txtFuncionario'),
            TERCEIRO: pegaChave('#txtMotivo'),
            COM1: pegaValor('#txtComFat'),
            COM2: pegaValor('#txtComRec'),
            TAB_PRE: pegaChave('#txtTabelaPreco'),
            BLOQ_COM: pegaValor('#selectStatusComercial'),
            DT_CADASTRO: pegaValor('#dtEmissao'),
            DT_INICIO: pegaValor('#dtEmissao'),
            DT_VALIDADE: pegaValor('#dtValidade'),
            DIAS_ENTREGA: pegaValor('#txtDias'),
            OBSERVACAO: pegaValor('#txtObservacao'),
            SITUACAO: $('#rdSituacaoAberto').is(':checked') ? 'A' : $('#rdSituacaoFechado').is(':checked') ? 'F' : $('#rdSituacaoEmAprov').is(':checked') ? 'E' : $('#rdSituacaoPerdido').is(':checked') ? 'P' : '',
            SOMA_DIAS_ENT: $('#rdSumDiasCorridos').is(':checked') ? 'C' : 'U',
            MOEDA: pegaChave('#txtMoeda'),
            HISTORICO: pegaChave('#txtHistorico'),
            SIT_DUP: pegaChave('#txtSituacao'),
            CLASSE_GER: pegaChave('#txtClasseGer'),
            TAB_TRANS: pegaChave('#txtTransportadora'),
            CIF: $('#rgTransportador').val(),
            FRETE: pegaValor('#txtValorFrete'),
            PAGTO: prazo,
            DESCONTO: parseFloat(pegaValor('#txtDesconto')),
            DESC_UNIFICADO: campoDesconto(parseFloat($('#txtDesconto1').val()), parseFloat($('#txtDesconto2').val()), parseFloat($('#txtDesconto3').val()), parseFloat($('#txtDesconto4').val()), parseFloat($('#txtDesconto5').val())),
            TELA: 'SERVOS2',
            TELA_CRIACAO: 'SERVOS2',
            ITENS: arrayItens,
            EMP_ID: getCookie('emp_id'),
        };

        const response = await requisicao('POST', '/sisplan/os/v1/ordemservico?', '', `JSON=${encodeURIComponent(JSON.stringify(classOs))}`, 90000);

        if (!response) {
            return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            throw new Error(jsonStr.mensagem);
        }
    }

    function adicionaPesquisaAutocompleta() {
        $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
        $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa Cliente');
        $('#btn-limpa-cliente').on('click', function () { $('#txtCliente').val('') });

        $('#txtVendedor').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null}`);
        $('#btn-vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'Pesquisa Vendedor', 'represen');
        $('#btn-limpa-vendedor').on('click', function () { $('#txtVendedor').val('') });

        $('#txtFuncionario').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}`);
        $('#btn-funcionario').pesquisa('#txtFuncionario', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Funcionario', 'pessoal');
        $('#btn-limpa-funcionario').on('click', function () { $('#txtFuncionario').val('') });

        $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}`);
        $('#btn-transportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Transportadora', 'tabtran');
        $('#btn-limpa-transportadora').on('click', function () { $('#txtTransportadora').val('') });

        $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
        $('#btn-TabelaPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}', 'Pesquisa Tabela de Preço', 'REGIAO');
        $('#btn-limpa-TabelaPreco').on('click', function () { $('#txtTabelaPreco').val('') });

        $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
        $('#btn-motivo').pesquisa('#txtMotivo', 'CODMEN', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO" ], "where": null}', 'Pesquisa de Motivos', 'MENSAGEM');
        $('#btn-limpa-motivo').on('click', function () { $('#txtMotivo').val('') });

        $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
        $("#btn-Produto").pesquisa_serverside(["#txtProduto"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ]}`, "Pesquisa Produto");
        $('#btn-limpa-Produto').on('click', function () { $('#txtProduto, #txtValor, #txtQuantidadeEstoque').val('') });

        $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
        $("#btn-situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
        $("#btn-limpa-situacao").on("click", function () { $("#txtSituacao").val(""); });

        $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
        $("#btn-classeGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
        $("#btn-limpa-classeGer").on("click", function () { $("#txtClasseGer").val(""); });

        $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
        $("#btnMoeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
        $("#btnAMoeda").on("click", function () { $("#txtMoeda").val(""); });

        $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
        $("#btn-historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
        $("#btn-limpa-historico").on("click", function () { $("#txtHistorico").val(""); });

        $("#txtProduto").autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
        $("#btn-Produto").pesquisa_serverside(["#txtProduto"], ["PRODUTO.CODIGO"], ["PRODUTO.DESCRICAO"], `{"tabela": "PRODUTO",
        "camposSelect": ["PRODUTO.CODIGO",
            "PRODUTO.DESCRICAO",
            "PRODUTO.CODIGO2",
            "PRODUTO.CODCLI",
            "ENTIDADE.NOME",
            "PRODUTO.LINHA",
            "LINHA.DESCRICAO",
            "PRODUTO.GRUPO",
            "GRUPO.DESCRICAO",
            "PRODUTO.ETIQUETA",
            "ETIQUETA.DESCRICAO",
            "PRODUTO.COLECAO",
            "COLECAO.DESCRICAO",
            "PRODUTO.STATUS",
            "STATUS.DESCRICAO",
            "PRODUTO.MARCA",
            "MARCA.DESCRICAO",
            "PRODUTO.MODELO",
            "MODELO.DESCRICAO"],
        "leftJoin": [{"tabela": "ENTIDADE", "condicao": "PRODUTO.CODCLI = ENTIDADE.CODCLI"},
        {"tabela": "TABLIN", "alias": "LINHA", "condicao": "PRODUTO.LINHA = LINHA.CODIGO"},
        {"tabela": "GRUPO_PA", "alias": "GRUPO","condicao": "PRODUTO.GRUPO = GRUPO.CODIGO"},
        {"tabela": "ETQ_PROD", "alias": "ETIQUETA", "condicao": "PRODUTO.ETIQUETA = ETIQUETA.CODIGO"},
        {"tabela": "COLECAO", "condicao": "PRODUTO.COLECAO = COLECAO.CODIGO"},
        {"tabela": "SITPROD", "alias": "STATUS", "condicao": "PRODUTO.STATUS = STATUS.CODIGO"},
        {"tabela": "MARCA", "condicao": "PRODUTO.MARCA = MARCA.CODIGO"},
        {"tabela": "MODELO", "condicao": "PRODUTO.MODELO = MODELO.CODIGO"}],
        "where": ["PRODUTO.CODIGO <> ''"]}`, "Pesquisa Produto");
        $("#btn-limpa-Produto").on("click", function () {
            $("#txtProduto").val("");
            $('#txtCorProduto').val('');
            $('#txtFaixa').val('');
            $('.rgTipoItem').prop('disabled', false)
            limpaTabelaGrade()
        });

        $("#txtMaterial").autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
        $("#btn-Material").pesquisa("#txtMaterial", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Material", "MATERIAL");
        $("#btn-limpa-Material").on("click", function () {
            $("#txtMaterial").val("");
            $('#txtCorMaterial').val('');
            $('#txtFaixa').val('');
            $('.rgTipoItem').prop('disabled', false)
            limpaTabelaGrade()
        });

        $("#txtCorProduto").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
        $("#btn-CorProduto").pesquisa("#txtCorProduto", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
        $("#btn-limpa-CorProduto").on("click", function () { $("#txtCorProduto").val(""); });

        $("#txtCorMaterial").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
        $("#btn-CorMaterial").pesquisa("#txtCorMaterial", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
        $("#btn-limpa-CorMaterial").on("click", function () { $("#txtCorMaterial").val(""); });
    };

    async function carregaValoresPadroes() {
        const jsonStr = await buscaValoresPadroes('ORCAMENTO')

        jsonStr.map(item => {
            switch (item.CAMPO) {
                case 'MOEDA': {
                    if (item.VALOR != '') {
                        insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
                    }
                    break;
                }
                case 'HISTORICO': {
                    if (item.VALOR != '') {
                        insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
                    }
                    break;
                }
                case 'SITUACAO': {
                    if (item.VALOR != '') {
                        insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    }
                    break;
                }
                case 'CLASSEGER': {
                    if (item.VALOR != '') {
                        insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    }
                    break;
                }
                case 'TABPRECO': {
                    if (item.VALOR != '') {
                        insereValor('#txtTabPreco', item.VALOR, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: item.VALOR });
                    }
                    break;
                }
                case 'STATUS': {
                    if (item.VALOR != '') {
                        $('#selectStatusComercial').val(item.VALOR).trigger('change')
                    }
                    break;
                }
                case 'DIAS': {
                    if (item.VALOR != '') {
                        $('#txtDias').val(item.VALOR)
                        $('#txtDias').trigger('blur')
                    }
                    break;
                }

            }
        });
    };

    async function preencheDadosOrcamento(data) {
        $('#txtNumero').val(data.NUMERO)
        bloqueiaCampoNumero()
        $('#dtEmissao').val(data.DT_EMISSAO)
        $('#txtDias').val(data.DIAS_ENTREGA)
        $('#dtValidade').val(data.DT_VALIDADE)
        $('#rdSumDiasCorridos').prop('checked', data.SOMA_DIAS_ENT == 'C')
        $('#rdSumDiasUteis').prop('checked', data.SOMA_DIAS_ENT == 'U')
        insereValor('#txtCliente', data.CODCLI, data.NOME_CLI)
        insereValor('#txtFuncionario', data.FUNCIONARIO, data.NOME_FUNC)
        insereValor('#txtVendedor', data.VENDEDOR, data.NOME_VENDEDOR)
        $('#txtComFat').val(data.COM1)
        $('#txtComRec').val(data.COM2)
        $('#txtValorFrete').val(data.FRETE)
        if (data.TAB_PRE == '999') {
            $('#checkPrecoManual').prop('checked', true)
            tabelaPrecoManual()
        } else {
            insereValor('#txtTabelaPreco', data.TAB_PRE, data.DESC_TAB)
        }
        $('#rgTransportador').val(data.CIF)
        insereValor('#txtTransportadora', data.TAB_TRANS, data.NOME_TRAN)
        insereValor('#txtMotivo', data.TERCEIRO, data.DESC_MOTIVO)
        switch (data.SITUACAO) {
            case 'A': {
                $('#rdSituacaoAberto').prop('checked', true)
                break
            }
            case 'F': {
                $('#rdSituacaoFechado').prop('checked', true)
                break
            }
            case 'E': {
                $('#rdSituacaoEmAprov').prop('checked', true)
                break
            }
            case 'P': {
                $('#rdSituacaoPerdido').prop('checked', true)
                break
            }
            default: break
        }
        $('#selectStatusComercial').val(data.BLOQ_COM)
        $('#txtObservacao').val(data.OBSERVACAO)

        await preencheCondicao(data.PAGTO)
        $('#txtDesconto').val(data.DESCONTO)
        insereValor('#txtMoeda', data.MOEDA, data.DESC_MOEDA)
        insereValor('#txtHistorico', data.HISTORICO, data.DESC_HISTORICO)
        insereValor('#txtSituacao', data.SIT_DUP, data.DESC_SIT)
        insereValor('#txtClasseGer', data.CLASSE_GER, data.DESC_CLASSE)
    }

    async function preencheItensOrcamento(itens) {
        itens.map(item => {
            $('#tabelaItens').DataTable().row.add({
                ORDEM: item.ORDEM,
                TIPO: item.TIPO,
                CODIGO: item.CODIGO,
                DESCRICAO: item.DESCRICAO,
                COMPL_PROD: item.COMPL_PROD,
                COR: item.COR,
                DESCCOR: item.DESC_COR,
                TAM: item.TAM,
                QTDE: parseInt(item.QTDE),
                PRECO: parseFloat(item.PRECO) || 0,
                DESCONTO: parseFloat(item.DESC_ITEM) || 0,
                ACRESCIMO: parseFloat(item.ACRES_ITEM) || 0,
                VALOR: parseFloat(item.VALOR_TOTAL),
                OBSERVACAO: item.OBSERVACAO,
                FAIXA: item.FAIXA,
            }).draw(false);
        })
        calculaTotais()
    }

    async function preencheCondicao(condicao) {
        $.LoadingOverlay('show')
        try {
            $('#txtCondPagto1').val(condicao.substring(0, 3).replace(' ', ''))
            $('#txtCondPagto2').val(condicao.substring(3, 6).replace(' ', ''))
            $('#txtCondPagto3').val(condicao.substring(6, 9).replace(' ', ''))
            $('#txtCondPagto4').val(condicao.substring(9, 12).replace(' ', ''))
            $('#txtCondPagto5').val(condicao.substring(12, 15).replace(' ', ''))
            $('#txtCondPagto6').val(condicao.substring(15, 18).replace(' ', ''))
            $('#txtCondPagto7').val(condicao.substring(18, 21).replace(' ', ''))
            $('#txtCondPagto8').val(condicao.substring(21, 24).replace(' ', ''))
            $('#txtCondPagto9').val(condicao.substring(24, 27).replace(' ', ''))
            $('#txtCondPagto10').val(condicao.substring(27, 30).replace(' ', ''))
            $('#txtCondPagto11').val(condicao.substring(30, 33).replace(' ', ''))
            $('#txtCondPagto12').val(condicao.substring(33, 36).replace(' ', ''))
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }
});
