$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    })
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova operação.",
          position: "right",
        },
      },
      {
        element: "#tabelaItens",
        popover: {
          title: "Tabela de Operações",
          description: "Aqui está a lista de operações cadastradas.",
          position: "top",
        },
      },
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos('ORCAMENTO_TINGIMENTO');

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show')
  })

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI === 'S') {
      window.location.href = 'orcamento_tingimento/create'
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  })

  componenteFiltro('orcamentoTingimento', true, true, 'Numero')
  componenteFiltro('entidade', true, true, 'Cliente')
  componenteFiltro('grupoVenda', true, true, 'Tipo')
  componenteFiltro('variante', true, true, 'Composicao')

  $('#btnConsultar').on('click', function () {
    consultar().then(() => $('#modal-filtros').modal('hide'))
  })

  async function retornarFiltros() {
    const emissao = {
      de: $('#txtEmissaoDe').val(),
      ate: $('#txtEmissaoAte').val(),
    }
    const numero = await formataListas($('#txtNumero').val().toString())
    const cliente = await formataListas($('#txtCliente').val().toString())
    const tipo = await formataListas($('#txtTipo').val().toString())
    const composicao = await formataListas($('#txtComposicao').val().toString())

    return {
      emissao,
      numero,
      cliente,
      tipo,
      composicao,
    }
  }

  async function consultar() {
    const filtros = await retornarFiltros()
    carregarTabelaItens(filtros)
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      // '    <button class="dropdown-item" type="button" title="Imprimir" id="btnVisualizar">Imprimir</button>     ' +
      '    <button class="dropdown-item" type="button" title="Solicitar Amostra" id="btnSolicitarAmostra">Solicitar Amostra</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '</div>'
    return retorno
  }

  function carregarTabelaItens(filtros) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }

    const columns = [
      {
        data: 'id',
        title: 'Id',
        render: function (data) {
          return retornarBotaoOpcoes(data);
        },
      },
      {
        data: 'numero',
        title: 'Número',
      },
      {
        data: 'nomeCliente',
        title: 'Cliente',
      },
      {
        data: 'nomeRepresentante',
        title: 'Representante',
      },
      {
        data: 'emissao',
        title: 'Emissão',
        render: function (data) {
          return retornarDataISOEmYMD({
            dataISO: data, usarUTC: true, reverso: true
          })
        }
      },
      {
        data: 'validade',
        title: 'Validade',
        render: function (data) {
          return retornarDataISOEmYMD({
            dataISO: data, usarUTC: true, reverso: true
          })
        }
      },
      {
        data: 'descTipo',
        title: 'Tipo',
      },
      {
        data: 'descComposicao',
        title: 'Composição',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'prazoPagamento',
        title: 'Prazo de Pagamento',
      },
      {
        data: 'codMarkup',
        title: 'Markup',
      },
      {
        data: 'situacao',
        title: 'Situação',
        visible: false,
      }
    ]

    const tabela = $('#tabelaItens').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: true,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      colReorder: true,
      serverSide: true,
      ajax: {
        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/orcamento_tingimento/v1/orcamento_varios`,
        type: "POST",
        headers: {
          'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
        },
        data: function (data) {
          const { start, length, draw } = data;
          return JSON.stringify({
            filtros,
            paginacao: {
              recsMax: length,
              recsSkip: start,
              requestCount: draw,
            },
            empresa: getCookie('empresa')
          })
        },
        dataSrc: function (json) {
          if (!json || !json.data) {
            return []
          }
          return json.data
        },
        cache: true,
        beforeSend: function () {
          $.LoadingOverlay('show')
        },
        complete: function () {
          $.LoadingOverlay('hide')
          $('#tabelaItens').DataTable().row(':first').select()
        },
      },
      autoWidth: true,
      columns,
      scrollX: true,
      scrollY: '40vh',
      select: {
        style: 'single',
        toggleable: false,
      },
    })

    tabela.off('select')
    tabela.on('select', function (_e, _dt, type, indexes) {
      if (type === 'row') {
        const data = tabela.rows(indexes[0]).data().toArray()
        carregarPantones(data[0]?.id ?? '')
      }
    })
  }

  $('#tabelaItens').on('draw.dt', function () {
    setTimeout(() => {
      $('#tabelaItens').DataTable().columns.adjust()
    }, 1000)
  })

  async function carregarPantones(id) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('GET', `/sisplan/orcamento_tingimento/v1/pantones?`, `ID=${id}`, '', 3600000)
      const json = await response.json()

      if (!json) {
        throw new Error()
      }
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      carregarTabelaPantones(resultado)
    } catch (error) {
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function carregarTabelaPantones(data) {
    if ($.fn.DataTable.isDataTable('#tabelaPantones')) {
      $('#tabelaPantones').DataTable().destroy()
      $('#tabelaPantones').empty()
    }

    const columns = [
      {
        data: 'ordem',
        title: 'Ordem',
      },
      {
        data: 'tipo',
        title: 'Tipo',
      },
      {
        data: 'codigoPantone',
        title: 'Pantone',
      },
      {
        data: 'descPantone',
        title: 'Descrição',
      },
      {
        data: 'amostra',
        title: 'Amostra',
        render: function (data) {
          if (data === true) {
            return 'Sim'
          }

          return 'Não'
        }
      },
    ]

    $('#tabelaPantones').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '300px',
      select: {
        style: 'single',
        toggleable: false,
      },
    })
  }

  $('#btnLimparFiltros').on('click', function () {
    $('#txtEmissaoDe').val('1200-01-01')
    $('#txtEmissaoAte').val('2500-12-31')
    $('#txtNumero').empty().trigger('change')
    $('#txtCliente').empty().trigger('change')
    $('#txtTipo').empty().trigger('change')
    $('#txtComposicao').empty().trigger('change')
  })

  $('#formAmostra').validate({
    rules: {
      responsavel: {
        required: true,
      },
      telefone: {
        required: true,
      },
      endereco: {
        required: true,
      }
    },
    messages: {
      responsavel: 'Responsável é obrigatório.',
      telefone: 'Telefone é obrigatório.',
      endereco: 'Endereço é obrigatório.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      confirmarAmostra()
    }
  })

  function retornarDadosAmostra() {
    const id = $('#txtIdAmostra').val()
    const responsavelAmostra = $('#txtResponsavelAmostra').val()
    const telefoneResponsavel = $('#txtTelefoneAmostra').val()
    const enderecoResponsavel = $('#txtEnderecoAmostra').val()
    const lote = $('#txtLoteAmostra').val()

    return {
      id,
      responsavelAmostra,
      telefoneResponsavel,
      enderecoResponsavel,
      lote,
    }
  }

  async function confirmarAmostra() {
    try {
      $.LoadingOverlay('show')
      const dados = retornarDadosAmostra()
      const response = await requisicao('PUT', `/sisplan/orcamento_tingimento/v1/amostra?`, ``, JSON.stringify(dados), 3600000)
      const json = await response.json()

      if (!json) {
        throw new Error()
      }
      const { mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          consultar()
          $('#txtIdAmostra').val('')
          $('#txtClienteAmostra').val('')
          $('#txtResponsavelAmostra').val('')
          $('#txtTelefoneAmostra').val('')
          $('#txtEnderecoAmostra').val('')
          $('#txtLoteAmostra').val('')
          $('#modal-solicitar-amostra').modal('hide')
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })

    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao gravar os dados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#tabelaItens').on('click', '#btnVisualizar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      if (data) {
        if (!!data.utilizado) {
          msgErro('Kit já foi utilizado para realizar uma venda, impossível continuar.')
          return
        }
        let registroLiberado = await verificarRegistro('FORMACAO_KIT', data?.produto)
        if (registroLiberado) {
          window.location.href = `formacao_kit/PRODUTO=${encodeURIComponent(data.produto)}&NUMERO=${encodeURIComponent(data.numero)}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  })

  const SPMaskBehavior = function (val) {
    return val.replace(/\D/g, "").length === 9 ? "00000-0000" : "0000-00009";
  }
  const spOptions = {
    onKeyPress(val, e, field, options) {
      field.mask(SPMaskBehavior.apply({}, arguments), options);
    },
  }

  $("#txtTelefoneAmostra").mask(SPMaskBehavior, spOptions);

  $('#tabelaItens').on('click', '#btnSolicitarAmostra', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      if (!data) {
        return
      }
      $('#txtIdAmostra').val(data.id)
      $('#txtClienteAmostra').val(data.nomeCliente)
      $('#txtResponsavelAmostra').val(data.responsavelAmostra)
      $('#txtTelefoneAmostra').val(data.telefoneResponsavel)
      $('#txtEnderecoAmostra').val(data.enderecoResponsavel)
      $('#txtLoteAmostra').val(data.lote)
      $('#modal-solicitar-amostra').modal('show')
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  })

  $('#tabelaItens').on('click', '#btnExcluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const row = $('#tabelaItens').DataTable().row($(this).parents('tr'))
      let data = row.data()
      if (!data) {
        return
      }
      if (data.situacao !== 'A') {
        msgErro('Orçamento não está em aberto, impossível excluir.')
        return
      }
      msgAlerta(
        'Deseja excluir o orçamento selecionado?',
        () => { },
        () => { },
        () => excluir(data?.id, row),
      )
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  })

  async function excluir(id, row) {
    if (!id || !row) return
    $.LoadingOverlay('show')
    requisicao("DELETE", `/sisplan/orcamento_tingimento/v1/orcamento?`, `ID=${id}`, '', 3600000)
      .then(async (response) => {
        if (response.status !== 204) {
          const json = await response.json()
          console.error(json?.mensagem?.mensagem)
          throw json?.mensagem?.mensagem
        }

        toastr.success("Orçamento excluído com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            row.remove().draw(false)
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => msgErro(error || 'Ocorreu um erro ao realizar a exclusão.')
      ).finally(() => $.LoadingOverlay('hide'))
  }

  consultar()
})