<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cadastro de Limite de Orçamento Caixa</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2511.28.1">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2511.28.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2511.28.1" />
    <link href='../dist/css/bootstrap.min.css?versao=3.2511.28.1'>
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2511.28.1">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2511.28.1">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.28.1">
    <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2511.28.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.2511.28.1">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.2511.28.1">
    <!-- Toastr -->
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2511.28.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2511.28.1" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2511.28.1">
    <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.2511.28.1">
    <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.2511.28.1">
    <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.28.1">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        #progressbar li {
            list-style-type: none;
            font-size: 12px;
            width: 100%;
            float: left;
            position: relative
        }

        .labelGeral {
            margin-top: 7px;
            margin-bottom: 3px;
        }

        .labelCheck {
            font-size: 120%;
            /* border-bottom: outset 2px;
            border-left: outset 2px; */
            padding: 0.2%;
            margin-left: 1%;
        }

        .configCheck {
            -ms-transform: scale(1.5);
            -moz-transform: scale(1.5);
            -webkit-transform: scale(1.5);
            -o-transform: scale(1.5);
            transform: scale(1.5);
            padding: 10px;
        }

        .radioTipo {
            font-size: 120%;
        }

        .bTipo {
            position: absolute;
            margin-bottom: 50%;
            font-size: 120%;
            font-weight: bolder;
        }

        .pTipo {
            margin-top: 2%;
            margin-left: -1%;
            margin-bottom: 0%;
        }

        .pCartao {
            margin-left: -1%;
            margin-bottom: 0%;
            margin-top: 2%;
        }

        .valMin {
            margin-top: 2%;
        }

        .frete {
            margin-top: 2%;
            margin-left: 0.1%;
        }

        #contas-wrap {
            margin-top: 0%;
        }

        #labelcontas {
            margin-top: 2%;
        }

        .radioTop {
            margin-left: 2%;
            margin-top: 2%;
        }

        .labelFonte {
            font-size: 100%;
            margin-top: 20%;
        }

        .radiosStyle {
            font-size: 120%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .checkboxMoeda {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 1.6%;
            padding-bottom: 0%;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            ;
            padding: 0 1.0em 0 1.0em !important;
            margin: 0 0 0 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
        }

        .form-group {
            margin-bottom: 0 !important;
        }

        .icheck-primary {
            margin-top: 0 !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

        <div id="myModal" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 id="myModalLabel" class="modal-title"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p id="myModalText"></p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                        <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <section class="content">
                <div class="content-header">
                    <div class="row justify-content-center mt-0">
                        <div class="col-10 text-center p-0 mt-3 mb-2">
                            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                                    <h2>Cadastro de Limite de Orçamento Caixa
                                    </h2>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mx-0">
                                        <form id="msform">
                                            <ul id="progressbar">
                                                <li class="active" id="account"><strong>Geral</strong></li>
                                            </ul>
                                            <p>Preencha os dados e clique em gravar para realizar o cadastro ou alteração do Limite de Orçamento.</p>

                                            <fieldset>
                                                <div class="form-card" id="formcard1">
                                                    <div class="row">
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtMoeda">Moeda:</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" placeholder="Moeda">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnAMoeda" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group col-lg-8 col-12">
                                                            <label for="txtDataDe" class="labelGeral">Data de/até:</label>
                                                            <div class="relative">
                                                                <div class="input-group">
                                                                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataDe" name="DataDe">
                                                                    <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtDataAte" name="DataDe">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtValor">Valor: </label>
                                                            <input type="number" class="input-default focus form-control" id="txtValor" aria-describedby="descError" name="txtValor" class="form-control" placeholder="Valor">
                                                        </div>
                                                        <div class="form-group col-lg-8 col-12">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmpresa">Empresas:</label>
                                                            <div class="input-group">
                                                                <select class="js-example-programmatic js-states form-control" id="txtEmpresa" name="txtEmpresa" multiple="multiple">
                                                                </select>
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnEmpresa" name="btnEmpresa" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnLimpaEmpresa" name="btnLimpaEmpresa" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="button" name="next" class="btn-sisp action-button" value="Gravar" id="gravar" />
                                                <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                                            </fieldset>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <?php
    include_once('../../../modais.php');
    ?>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
        <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
    </div>

    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.2511.28.1"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.28.1"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2511.28.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2511.28.1"></script>
    <!-- SweetAlert2 -->
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2511.28.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.2511.28.1"></script>

    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>

    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/cliente/entidade.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2511.28.1"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.2511.28.1"></script>
    <script src="../utils/funcoes.js?versao=3.2511.28.1"></script>
    <script src="../utils/cookies.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/driver.min.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/jquery.mask.min.js?versao=3.2511.28.1"></script>
    <script src="../dist/js/dataTables.keyTable2.js?versao=3.2511.28.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.2511.28.1"></script>
    <script src="../plugins/select2/js/select2.full.min.js?versao=3.2511.28.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('LIMITE_ORCAMENTO_CAIXA');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            const permissaoUsuarioLogado = await permissaoAcessos("LIMITE_ORCAMENTO_CAIXA");

            if (permissaoUsuarioLogado.INCLUI == 'N') {
                await criaMensagemErro("Sem permissão para incluir!", () => {
                    window.location.href = `${BASE_URI}/limiteorcamentocaixa`
                });
                return;
            }

            const queryString = window.location.href;
            const parametros = queryString.split("/");
            const limite_orcamento_caixa = parametros[parametros.length - 1];

            $(window).on("beforeunload", function(e) {
                // e.preventDefault();
                e.stopPropagation();
                deletaRegistro("LIMITE_ORCAMENTO_CAIXA", getCookie("usuario"), limite_orcamento_caixa);
                return undefined;
            });

            sArquivo = `${BASE_URI}/pages/limiteorcamentocaixa/cadastro_limiteorcamentocaixa/limiteorcamentocaixa.js?versao=3.2511.28.1`;
            insereJavaScriptPagina(sArquivo);

            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>