$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#abaGeral',
                popover: {
                    title: 'Campos de Filtro',
                    description: 'Campos para filtrar o pedido a ser liberado.',
                    position: 'bottom'
                }
            },
            {
                element: '#btnConsultar',
                popover: {
                    title: 'Botão Consultar',
                    description: 'Clique aqui para realizar a consulta de pedidos.',
                    position: 'left'
                }
            },
            {
                element: '#btnLiberar',
                popover: {
                    title: 'Botão Confirmar',
                    description: 'Clique aqui para liberar/bloquear os pedidos selecionados.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    addPesquisaAutocompleta();
    let selectUmaCor = false;

    $('#cbEstoquePositivo').on('change', async function () {
        if ($(this).is(':checked')) {
            $('#pnlDeposito').removeClass('d-none')
        } else {
            $('#pnlDeposito').addClass('d-none')
            $('#txtDeposito').val('')
        }
    })

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            if ($.fn.DataTable.isDataTable('#tabelaProdutos')) {
                $("#tabelaProdutos").DataTable().destroy();
                $("#tabelaProdutos").empty();
            };
            if ($.fn.DataTable.isDataTable('#tabelaCor')) {
                $("#tabelaCor").DataTable().destroy();
                $("#tabelaCor").empty();
            };
            if ($.fn.DataTable.isDataTable('#tabelaTam')) {
                $("#tabelaTam").DataTable().destroy();
                $("#tabelaTam").empty();
            };

            $('.visibleAposConsulta').addClass('d-none')
            await buscaDados()
            $('.visibleAposConsulta').removeClass('d-none')

            await selecionaProdutos()

            $('#tabelaProdutos tbody tr:first').trigger('click');
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function selecionaProdutos() {
        $("#tabelaProdutos").DataTable().page.len(200).draw(false);
        $($(".page-link")[1]).trigger("click");
        await sleep(10);
        const totalPaginas = $("#tabelaProdutos").DataTable().page.info().pages;

        for (let i = 1; i <= totalPaginas; i++) {
            const totalRegistrosPagina = $("#tabelaProdutos").DataTable().page.info().end - $("#tabelaProdutos").DataTable().page.info().start;

            for (let j = 0; j < totalRegistrosPagina; j++) {
                await sleep(10);
                const checkbox = $(`#check_col_0_row_${j}`);
                const item = $("#tabelaProdutos").DataTable().data().toArray()[j]

                if (item.SEL == 'S'){
                    checkbox.trigger('click');
                }
                
            }
            if (i < totalPaginas) {
                $("#tabelaProdutos_next").trigger("click");
                await sleep(10);
            } else {
                $($(".page-link")[1]).trigger("click");
                $("#tabelaProdutos").DataTable().page.len(10).draw(false);
            }
        }

        $('#tabelaProdutos tbody tr:first').trigger('click');
    }

    async function retornaFiltros() {
        const filtros = `PRODUTO=${pegaChave('#txtProduto')}` +
            `&COLECAO=${await formataListas($('#txtColecao').val().toString())}` +
            `&LINHA=${pegaChave('#txtLinha')}` +
            `&MARCA=${pegaChave('#txtMarca')}` +
            `&STATUS=${pegaChave('#txtStatus')}` +
            `&ETIQUETA=${pegaChave('#txtEtiqueta')}` +
            `&TABELA=${pegaChave('#txtTabPreco')}` +
            `&DEPOSITO=${pegaChave('#txtDeposito')}` +
            `&ESTOQUEPOSITIVO=${$('#cbEstoquePositivo').is(':checked') ? 'S' : 'N'}` +
            `&ATUALIZACOLECAO=${$('#cbAtualizaColecao').is(':checked') ? 'S' : 'N'}`
        return filtros
    }

    async function buscaDados() {
        const url = "/sisplan/liberacaoforcavenda/v1/liberacaoforcavenda?";
        const filtros = await retornaFiltros()
        const response = await requisicao("GET", url, filtros, "", 360000);

        if (!response) {
            return;
        }

        const jsonStr = await response.json()
        if (response.status != 200) {
            throw new Error(jsonStr['RESULT'][0].mensagem);
        }

        if (jsonStr[0].length <= 0) {
            throw new Error('Nenhum registro encontrado!')
        }

        const tbCadastro = jsonStr[0]
        const tbCor = jsonStr[1]
        const tbTam = jsonStr[2]

        await montaDataTableProdutos(tbCadastro)
        await montaDataTableCor(tbCor)
        await montaDataTableTam(tbTam)

        const linhasVisiveis = $('#tabelaProdutos').DataTable().rows(':visible').nodes()
        if (linhasVisiveis.length > 0) {
            $(linhasVisiveis[0]).trigger('click')
        }
    }

    async function montaDataTableProdutos(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        dataSetCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check pl-0">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" id="check_col_${meta.col}_row_${meta.row}" class="align-self-center campoSel"><label for="check_col_${meta.col}_row_${meta.row}"></label>` +
                '</div>' +
                '</div>';
        }

        $('#tabelaProdutos').DataTable({
            bPaginate: true,
            search: false,
            destroy: true,
            colReorder: true,
            info: true,
            scrollX: true,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr
        });

        $('#tabelaProdutos').on('click', '.campoSel', async function () {
            $.LoadingOverlay('show')
            try {
                const row = parseInt(this.id.split('row_')[1].split('_col')[0])
                const produto = $('#tabelaProdutos').DataTable().row(row).data()
                if (this.checked) {
                    $('#tabelaProdutos').DataTable().row(row).data().SEL = 'S'
                } else {
                    $('#tabelaProdutos').DataTable().row(row).data().SEL = 'N'
                }

                if (selectUmaCor) {
                    return
                }

                for (let i = 0; i < $('#tabelaCor').DataTable().data().length; i++) {
                    const cor = $('#tabelaCor').DataTable().data()[i]
                    if (produto.CODIGO == cor.CODIGO) {
                        if (this.checked) {
                            if (!$(`#check_col_0_row_${i}_Cor`).is(':checked')) {
                                $(`#check_col_0_row_${i}_Cor`).trigger('click')
                            }
                        } else {
                            if ($(`#check_col_0_row_${i}_Cor`).is(':checked')) {
                                $(`#check_col_0_row_${i}_Cor`).trigger('click')
                            }
                        }
                    }
                }
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaProdutos tbody').on('click', 'tr', async function () {
            const item = $('#tabelaProdutos').DataTable().row($(this)).data()
            if ($(this).hasClass('selected')) {
                //aqui não faz nada ta
            } else {
                $('#tabelaProdutos').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                await ajustaDataTableCores(item)
            }
        });
    }

    async function montaDataTableCor(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        dataSetCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check pl-0">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" id="check_col_${meta.col}_row_${meta.row}_Cor" class="align-self-center campoCheck"><label for="check_col_${meta.col}_row_${meta.row}_Cor"></label>` +
                '</div>' +
                '</div>';
        }

        $('#tabelaCor').DataTable({
            bPaginate: false,
            search: false,
            destroy: true,
            colReorder: true,
            info: false,
            scrollX: true,
            scrollY: '200px',
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    targets: [1, 2, 5],
                    visible: false
                },
            ]
        });

        $('#tabelaCor').on('click', '.campoCheck', function () {
            $.LoadingOverlay('show')
            try {
                const row = parseInt(this.id.split('row_')[1].split('_col')[0])
                const cor = $('#tabelaCor').DataTable().row(row).data()
                if (this.checked) {
                    $('#tabelaCor').DataTable().row(row).data().SEL = 'S'
                } else {
                    $('#tabelaCor').DataTable().row(row).data().SEL = 'N'
                }

                for (let i = 0; i < $('#tabelaTam').DataTable().data().length; i++) {
                    const tam = $('#tabelaTam').DataTable().data()[i]
                    if (tam.CODIGO == cor.CODIGO && tam.COR == cor.COR) {
                        if (this.checked) {
                            if (!$(`#check_col_0_row_${i}_Tam`).is(':checked')) {
                                $(`#check_col_0_row_${i}_Tam`).trigger('click')
                            }
                        } else {
                            if ($(`#check_col_0_row_${i}_Tam`).is(':checked')) {
                                $(`#check_col_0_row_${i}_Tam`).trigger('click')
                            }
                        }
                    }
                }

                selectUmaCor = true

                for (let i = 0; i < $('#tabelaProdutos').DataTable().data().length; i++) {
                    const produto = $('#tabelaProdutos').DataTable().data()[i]
                    if (produto.CODIGO == cor.CODIGO) {
                        if ($('#tabelaCor').DataTable().data().toArray().filter(f => { return f.SEL == 'S' }).length > 0) {
                            if (!$(`#check_col_0_row_${i}`).is(':checked')) {
                                $(`#check_col_0_row_${i}`).trigger('click')
                            }
                        } else {
                            if ($(`#check_col_0_row_${i}`).is(':checked')) {
                                $(`#check_col_0_row_${i}`).trigger('click')
                            }
                        }
                    }
                }
                selectUmaCor = false
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaCor tbody').on('click', 'tr', async function () {
            const item = $('#tabelaCor').DataTable().row($(this)).data()
            if ($(this).hasClass('selected')) {
                //aqui não faz nada ta
            } else {
                $('#tabelaCor').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                await ajustaDataTableTam(item)
            }
        });
    }

    function retornaInputValor(sNomeInput, iIndex = 0, data) {
        return `<input type="text" class="input-default focus form-control camposMascaraQtde ${sNomeInput}" data-campo="${sNomeInput}" data-index="${iIndex}" id="txtQtdeTamanho${iIndex}" value="${data}">`
    };

    async function montaDataTableTam(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        dataSetCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check pl-0">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" id="check_col_${meta.col}_row_${meta.row}_Tam" class="align-self-center campoCheck"><label for="check_col_${meta.col}_row_${meta.row}_Tam"></label>` +
                '</div>' +
                '</div>';
        }

        dataSetCols[4].render = function (data, type, row, meta) {
            return retornaInputValor('txtQtdeTam', meta.row, data)
        }

        $('#tabelaTam').DataTable({
            bPaginate: false,
            search: false,
            destroy: true,
            colReorder: true,
            info: false,
            scrollX: true,
            scrollY: '150px',
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    targets: [1, 3, 5],
                    visible: false
                },
            ]
        });

        $(".camposMascaraQtde").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $(".camposMascaraQtde").on('blur', function () {
            if (($(this).val() == '0.00') || ($(this).val() == '')) {
                $(this).val('0.00');
            }
        });

        $('#tabelaTam').on('click', '.campoCheck', function () {
            const row = parseInt(this.id.split('row_')[1].split('_col')[0])
            if (this.checked) {
                $('#tabelaTam').DataTable().row(row).data().SEL = 'S'
            } else {
                $('#tabelaTam').DataTable().row(row).data().SEL = 'N'
            }
        });
    }

    async function ajustaDataTableCores(item) {
        if (item.CODIGO != '') {
            $('#tabelaCor tbody tr').each(function () {
                const codigo = $('#tabelaCor').DataTable().row($(this)).data().CODIGO
                if (codigo != item.CODIGO) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
            const linhasVisiveis = $('#tabelaCor').DataTable().rows(':visible').nodes()
            if (linhasVisiveis.length > 0) {
                $(linhasVisiveis[0]).trigger('click')
            }
        }
        await ajustaColumnsDataTable()
    }

    async function ajustaColumnsDataTable() {
        $('#tabelaProdutos').DataTable().columns.adjust().draw(false)
        $('#tabelaCor').DataTable().columns.adjust().draw(false)
        $('#tabelaTam').DataTable().columns.adjust().draw(false)
    }

    async function ajustaDataTableTam(item) {
        if ((item.CODIGO != '') && (item.COR != '')) {
            $('#tabelaTam tbody tr').each(function () {
                const codigo = $('#tabelaTam').DataTable().row($(this)).data().CODIGO
                const cor = $('#tabelaTam').DataTable().row($(this)).data().COR
                if (codigo == item.CODIGO && cor == item.COR) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        }
    }

    $('#checkSelecionarTodos').on('change', async function () {
        async function callBack() {
            $.LoadingOverlay("show");
            try {
                $("#tabelaProdutos").DataTable().page.len(200).draw(false);
                $($(".page-link")[1]).trigger("click");
                await sleep(10);
                const totalPaginas = $("#tabelaProdutos").DataTable().page.info().pages;
                const checkSelecionarTodos = $("#checkSelecionarTodos").prop("checked");

                for (let i = 1; i <= totalPaginas; i++) {
                    const totalRegistrosPagina = $("#tabelaProdutos").DataTable().page.info().end - $("#tabelaProdutos").DataTable().page.info().start;

                    for (let j = 0; j < totalRegistrosPagina; j++) {
                        await sleep(10);
                        const checkbox = $(`#check_col_0_row_${j}`);
                        if (checkSelecionarTodos) {
                            if (!checkbox.is(':checked')) {
                                checkbox.trigger('click');
                            }
                        } else {
                            if (checkbox.is(':checked')) {
                                checkbox.trigger('click');
                            }
                        }
                    }
                    if (i < totalPaginas) {
                        $("#tabelaProdutos_next").trigger("click");
                        await sleep(10);
                    } else {
                        $($(".page-link")[1]).trigger("click");
                        $("#tabelaProdutos").DataTable().page.len(10).draw(false);
                    }
                }

                $('#tabelaProdutos tbody tr:first').trigger('click');
            } finally {
                $.LoadingOverlay("hide");
            }
        }

        msgAlerta(
            `Tem certeza que deseja ${!$("#checkSelecionarTodos").prop("checked") ? "desmarcar" : "selecionar"} todos os registros? \nEssa ação percorrerá todas as páginas da tabela e resultará na seleção completa dos registros.`,
            callBack,
            () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
            undefined,
            () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
            true
        );
    });

    function validacaoConfirmaDados() {
        if ((!$.fn.DataTable.isDataTable('#tabelaProdutos')) || ($('#tabelaProdutos').DataTable().data().length <= 0)) {
            throw new Error('Não existem registros para serem alterados!')
        }
    }

    $('#btnConfirmar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            validacaoConfirmaDados()
            await confirmaDados()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function montaObjTam() {
        const array = []
        for (let i = 0; i < $('#tabelaTam').DataTable().data().toArray().length; i++) {
            const item = $('#tabelaTam').DataTable().data().toArray()[i]
            const obj = {
                SEL: item.SEL,
                CODIGO: item.CODIGO,
                TAM: item.TAM,
                COR: item.COR,
                QTDE: parseFloat($(`#txtQtdeTamanho${i}`).val()),
                ESTOQUE_ILIMITADO: item.ESTOQUE_ILIMITADO
            }
            array.push(obj)
        }

        return array
    }

    async function confirmaDados() {
        const tbCadastro = $('#tabelaProdutos').DataTable().data().toArray()
        const tbCor = $('#tabelaCor').DataTable().data().toArray()
        const tbTam = await montaObjTam()

        const url = "/sisplan/liberacaoforcavenda/v1/liberacaoforcavenda?";
        const body = `TBCADASTRO=${encodeURIComponent(JSON.stringify(tbCadastro))}&TBCOR=${encodeURIComponent(JSON.stringify(tbCor))}&TBTAM=${encodeURIComponent(JSON.stringify(tbTam))}`
        const response = await requisicao('POST', url, `&ATUALIZACOLECAO=${$('#cbAtualizaColecao').is(':checked') ? 'S' : 'N'}`, body, 360000);

        if (!response) {
            $.LoadingOverlay("hide");
            return;
        };

        let jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
        }
        $.LoadingOverlay("hide");
        toastr.success(
            'Registros Atualizados com Sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                $('#btnConsultar').trigger('click')
            }
        }
        ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
        });
    }

    function addPesquisaAutocompleta() {
        componenteFiltro('colecao', true, true)
        componenteFiltro('produto', false, false)
        componenteFiltro('linha')
        componenteFiltro('marca')
        componenteFiltro('status')
        componenteFiltro('etiqueta')
        componenteFiltro('tabPreco')
        componenteFiltro('deposito')
    }
});