<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Formação de Custo de Produto</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.28.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.28.1">
  <!--e1Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2511.28.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2511.28.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2511.28.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2511.28.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.6.0/css/select.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="../dist/css/sisplan.newColorsButtons.css?versao=3.2511.28.1" />

  <style>
    .table.dataTable tbody td,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .table.dataTable tbody tr.selected {
      font-weight: bold;
    }

    .content-wrapper {
      margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar {
      display: none;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 0 1em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    .placeholder-lowercase::placeholder {
      text-transform: none;
    }

    .inputInvisivel {
      max-width: 100%;
      min-width: 0px;
      width: 60px;
      text-align: center;
      width: auto;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>
    <div class="wrapper">


      <div id="myModal" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 id="myModalLabel" class="modal-title"></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <p id="myModalText"></p>
            </div>
            <div class="modal-footer">
              <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
              <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
          </div>
        </div>
      </div>

      <div class="content-wrapper">
        <section class="content">
          <div class="py-0">
            <div class="container-fluid">
              <div class="row mb-2">
                <div class="col-sm-6 flex">
                </div>
                <div class="col-sm-6">
                </div>
              </div>
            </div>
            <div class="row justify-content-center mt-0">
              <div class="col-12 p-0 mt-3 mb-2">
                <div class="container-fluid">
                  <div class="row mb-2 ml-2">
                    <div class="flex flex-1">
                      <h1 class="m-0 text-dark font-semibold" style="font-size: 1.8rem; font-weight: 500; line-height: 1.2;">Formação de Custos de Produto</h1>
                      <button class="btnTutorial" id="tutorial" style="max-height: 31px !important;">
                        <i class="fas fa-question-circle"></i>
                      </button>
                    </div>
                    <div class="col-auto">
                      <label data-error="wrong" data-success="right" for="txtParametro0Custos">Considerar cores *****:</label>
                      <select class="input-default focus form-control col-12" id="txtParametro0Custos">
                        <option value="0">Não</option>
                        <option value="1">Sim</option>
                      </select>
                    </div>
                    <div class="col-auto">
                      <label data-error="wrong" data-success="right" for="txtParametro1Custos">Calcular Média:</label>
                      <select class="input-default focus form-control col-12" id="txtParametro1Custos">
                        <option value="0">Tamanho</option>
                        <option value="1">Cor</option>
                        <option value="2">Tamanho e cor</option>
                        <option value="3">Média tamanho e cor</option>
                      </select>
                    </div>
                    <div class="col-auto">
                      <label data-error="wrong" data-success="right" for="txtParametro2Custos">Buscar mão de obra de:</label>
                      <select class="input-default focus form-control col-12" id="txtParametro2Custos">
                        <option value="0">Tempos (Custo)</option>
                        <option value="1">Setores</option>
                        <option value="2">Tempos (Preço Tempos)</option>
                        <option value="3">Preço Terceiros</option>
                      </select>
                    </div>
                  </div>
                </div>
                <div class="d-flex flex-row justify-content-center">
                  <div class="col-12 mx-0">
                    <form id="msform" class="text-left">
                      <fieldset class="d-flex pb-0">
                        <div class="pr-2 pl-0 py-0 col-12" id="formcard1">
                          <div id="tutorial-step1" class="flex flex-wrap w-100">
                            <div class="col-8 flex flex-wrap align-content-start px-0">
                              <div class="flex flex-wrap w-100">
                                <div class="col-xl-3 col-4 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código:</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control stepControl" id="txtCodigo" name="txtCodigo" placeholder="Código">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnCodigo" name="btnCodigo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btnLimpaCodigo" name="btnLimpaCodigo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-xl-4 col-4 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao">Descrição:</label>
                                  <input type="text" class="input-default focus form-control text-uppercase placeholder-lowercase stepControl disabledControl" disabled id="txtDescricao" name="txtDescricao" placeholder="Descrição">
                                </div>
                                <div class="col-xl-1 col-2 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidade">Unidade:</label>
                                  <input type="text" class="input-default focus form-control text-uppercase stepControl disabledControl" id="txtUnidade" disabled name="txtUnidade" placeholder="UN">
                                </div>
                                <div class="col-xl-2 col-3 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCadastro">Data Cadastro:</label>
                                  <input type="date" class="input-default focus form-control" value="<?php echo date('Y-m-d'); ?>" id="txtCadastro" name="txtCadastro">
                                </div>
                                <div class="col-xl-2 col-3 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAtualizacao">Data Atualização:</label>
                                  <input type="date" class="input-default focus form-control" value="<?php echo date('Y-m-d'); ?>" disabled id="txtAtualizacao" name="txtAtualizacao">
                                </div>
                              </div>
                              <div class="flex flex-wrap w-100">
                                <div class="col-xl-3 col-4 form-group d-none" id="divCor">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCor">Cor:</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control stepControl disabledControl" disabled id="txtCor" name="txtCor" placeholder="Cor">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger disabledControl" disabled id="btnCor" name="btnCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger disabledControl" disabled id="btnLimpaCor" name="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-xl-2 col-2 form-group d-none" id="divTamanho">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtTamanho">Tamanho:</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control text-uppercase stepControl disabledControl" id="txtTamanho" disabled name="txtTamanho" placeholder="">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger disabledControl" id="btnTamanho" disabled name="btnTamanho" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger disabledControl" id="btnLimpaTamanho" disabled name="btnLimpaTamanho" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="flex flex-wrap w-100">
                                <div class="col-xl-7 col-6 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarkup">Markup:</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control stepControl disabledControl" disabled id="txtMarkup" name="txtMarkup" placeholder="Markup">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger disabledControl" disabled id="btnMarkup" name="btnMarkup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger disabledControl" disabled id="btnLimpaMarkup" name="btnLimpaMarkup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-xl-1 col-2 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtIndiceMarkup">Índice:</label>
                                  <input type="text" class="input-default focus form-control text-right quatroCasasDecimaisQuantityFormat disabledControl" disabled id="txtIndiceMarkup" name="txtIndiceMarkup" placeholder="0,0000">
                                </div>
                                <div class="col-xl-1 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtStatus">Status:</label>
                                  <input type="text" class="input-default focus form-control" disabled id="txtStatus" name="txtStatus" value="Aberto">
                                </div>
                                <div class="col-xl-1 col-2 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtIdPreco">Id:</label>
                                  <input type="text" class="input-default focus form-control text-right disabledControl" disabled id="txtIdPreco" name="txtIdPreco" placeholder="0">
                                </div>
                                <div class="form-group form-check icheck-primary flex align-items-center pl-1" style="margin-bottom: 0 !important">
                                  <input type="checkbox" class="form-check-input" id="cbPadrao">
                                  <label class="form-check-label pr-4" for="cbPadrao">Padrão</label>
                                </div>
                              </div>
                              <div class="flex flex-wrap w-100">
                                <div class="flex flex-wrap" style="width: 65%">
                                  <div class="col-xl-2 col-2 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPesoBruto">Peso B.:</label>
                                    <input type="text" class="input-default focus form-control text-right seisCasasDecimaisQuantityFormat stepControl disabledControl" id="txtPesoBruto" name="txtPesoBruto" placeholder="0,000000">
                                  </div>
                                  <div class="col-xl-2 col-2 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPesoLiquido">Peso L.:</label>
                                    <input type="text" class="input-default focus form-control text-right seisCasasDecimaisQuantityFormat stepControl disabledControl" id="txtPesoLiquido" name="txtPesoLiquido" placeholder="0,000000">
                                  </div>
                                  <div class="col-xl-2 col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuebra">% Quebra:</label>
                                    <input type="text" class="input-default focus form-control text-right seisCasasDecimaisQuantityFormat stepControl disabledControl" id="txtQuebra" name="txtQuebra" placeholder="0,000000">
                                  </div>
                                  <div class="col-xl-2 col-2 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPerda">% Perda:</label>
                                    <input type="text" class="input-default focus form-control text-right disabledControl" disabled id="txtPerda" name="txtPerda" placeholder="0,000000">
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="col-4 flex flex-wrap px-0">
                              <div class="flex flex-wrap w-50 align-content-start">
                                <div class="col-6 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCotacaoDolar">Cotação Dólar:</label>
                                  <input type="text" class="input-default focus form-control text-right duasCasasDecimaisQuantityFormat" disabled id="txtCotacaoDolar" name="txtCotacaoDolar" placeholder="0,00">
                                </div>
                                <div class="col-6 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCotacaoEuro">Cotação Euro:</label>
                                  <input type="text" class="input-default focus form-control text-right duasCasasDecimaisQuantityFormat" disabled id="txtCotacaoEuro" name="txtCotacaoEuro" placeholder="0,00">
                                </div>
                                <div class="col-6 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrecoDolar">Preço Dólar:</label>
                                  <input type="text" class="input-default focus form-control text-right duasCasasDecimaisQuantityFormat" id="txtPrecoDolar" name="txtPrecoDolar" placeholder="0,00">
                                </div>
                                <div class="col-6 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrecoEuro">Preço Euro:</label>
                                  <input type="text" class="input-default focus form-control text-right duasCasasDecimaisQuantityFormat" id="txtPrecoEuro" name="txtPrecoEuro" placeholder="0,00">
                                </div>
                                <div class="col-6 form-group">
                                  <button type="button" class="btn btn-info btn-sisp w-100 px-0 d-none" style="min-width: auto" id="btnFotoProduto" title="Clique para carregar a foto do produto">Foto <i class="fas fa-camera"></i></button>
                                </div>
                                <div class="col-6 form-group">
                                  <button type="button" class="btn btn-info btn-sisp w-100 px-0" style="min-width: auto" id="btnMarkupProduto" title="Clique para carregar o markup do produto">Markup (F10)</button>
                                </div>
                              </div>
                              <div class="flex flex-wrap w-50">
                                <fieldset class="border-Field mb-3">
                                  <legend class="textoBorda mb-0 py-0 text-md">Prazo markup:</legend>
                                  <div class="flex flex-wrap px-xl-4 px-2 w-100">
                                    <div class="d-flex flex-column col-4">
                                      <span class="text-center text-md">Prazo</span>
                                      <input id="txtPrazo0" disabled class="inputInvisivel pr-1 d-none rowMarkup0 text-md" value="À vista" />
                                      <input id="txtPrazo1" disabled class="inputInvisivel pr-1 d-none rowMarkup1 text-md" />
                                      <input id="txtPrazo2" disabled class="inputInvisivel pr-1 d-none rowMarkup2 text-md" />
                                      <input id="txtPrazo3" disabled class="inputInvisivel pr-1 d-none rowMarkup3 text-md" />
                                      <input id="txtPrazo4" disabled class="inputInvisivel pr-1 d-none rowMarkup4 text-md" />
                                      <input id="txtPrazo5" disabled class="inputInvisivel pr-1 d-none rowMarkup5 text-md" />
                                      <input id="txtPrazo6" disabled class="inputInvisivel pr-1 d-none rowMarkup6 text-md" />
                                      <input id="txtPrazo7" disabled class="inputInvisivel pr-1 d-none rowMarkup7 text-md" />
                                    </div>
                                    <div class="d-flex flex-column col-4">
                                      <span class="text-center text-md">PC (R$)</span>
                                      <input id="txtValorPc0" disabled class="inputInvisivel pr-1 d-none rowMarkup0 text-md" />
                                      <input id="txtValorPc1" disabled class="inputInvisivel pr-1 d-none rowMarkup1 text-md" />
                                      <input id="txtValorPc2" disabled class="inputInvisivel pr-1 d-none rowMarkup2 text-md" />
                                      <input id="txtValorPc3" disabled class="inputInvisivel pr-1 d-none rowMarkup3 text-md" />
                                      <input id="txtValorPc4" disabled class="inputInvisivel pr-1 d-none rowMarkup4 text-md" />
                                      <input id="txtValorPc5" disabled class="inputInvisivel pr-1 d-none rowMarkup5 text-md" />
                                      <input id="txtValorPc6" disabled class="inputInvisivel pr-1 d-none rowMarkup6 text-md" />
                                      <input id="txtValorPc7" disabled class="inputInvisivel pr-1 d-none rowMarkup7 text-md" />
                                    </div>
                                    <div class="d-flex flex-column col-4">
                                      <span class="text-center text-md">KG (R$)</span>
                                      <input id="txtValorKg0" disabled class="inputInvisivel pr-1 d-none rowMarkup0 text-md" />
                                      <input id="txtValorKg1" disabled class="inputInvisivel pr-1 d-none rowMarkup1 text-md" />
                                      <input id="txtValorKg2" disabled class="inputInvisivel pr-1 d-none rowMarkup2 text-md" />
                                      <input id="txtValorKg3" disabled class="inputInvisivel pr-1 d-none rowMarkup3 text-md" />
                                      <input id="txtValorKg4" disabled class="inputInvisivel pr-1 d-none rowMarkup4 text-md" />
                                      <input id="txtValorKg5" disabled class="inputInvisivel pr-1 d-none rowMarkup5 text-md" />
                                      <input id="txtValorKg6" disabled class="inputInvisivel pr-1 d-none rowMarkup6 text-md" />
                                      <input id="txtValorKg7" disabled class="inputInvisivel pr-1 d-none rowMarkup7 text-md" />
                                    </div>
                                  </div>
                                </fieldset>
                              </div>
                            </div>
                          </div>
                          <div class="flex flex-wrap w-100">
                            <div class="d-flex flex-column col-8 pr-0" style="gap: 8px" id="divTabelaItens">
                              <div class="table-responsive" style="overflow-x: hidden">
                                <table id="tabelaItens" class="table table-sm table-select table-hover" width="100%">
                                  <thead>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                            <div class="col-4" id="divGraficoPercentuaisCusto">
                              <div class="w-100 h-full" id="graficoPercentualCusto"></div>
                            </div>
                          </div>
                          <div class="d-none">
                            <table id="tabelaComposicaoGravar" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="d-flex justify-content-start mt-2 flex-wrap align-items-end ml-2">
                            <div class="flex" style="gap: 8px">
                              <button type="button" class="btn btnVerde btn-sisp" id="btnGravar" style="max-height: 40px">Gravar</button>
                              <button type="button" class="btn btn-danger btn-sisp" id="btnVoltar" style="max-height: 40px">Desistir</button>
                              <button type="button" class="btn btn-primary btn-sisp" id="btnAlterar" style="max-height: 40px">Alterar</button>
                            </div>
                            <div class="col-auto ml-auto">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCustoTotal">Custo Total:</label>
                              <input type="text" class="input-default focus form-control text-right" disabled id="txtCustoTotal" name="txtCustoTotal" placeholder="0,0000">
                            </div>
                            <div class="col-auto pr-0">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCustoTotalComQuebra">Custo com Quebra:</label>
                              <input type="text" class="input-default focus form-control text-right" disabled id="txtCustoTotalComQuebra" name="txtCustoTotalComQuebra" placeholder="0,0000">
                            </div>
                          </div>
                        </div>
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
    </div>

    <div class="modal fade pr-0" data-backdrop="static" id="modalMarkup">
      <div class="modal-dialog" style="min-width: 90%; min-height: 100%">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloModalMarkup"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body p-1" id="modal-scroll">
            <div class="card mb-1">
              <div class="flex flex-wrap col-12 pb-2">
                <div class="flex flex-wrap col-xl-6 col-12">
                  <div class="col-xl-12 col-12">
                    <fieldset class="border-Field my-0 p-0" style="padding-bottom: 5px!important;">
                      <legend class="textoBorda mb-0 py-0 text-md">Índices:</legend>
                      <div class="col-xl-12 col-12 table-responsive" style="max-height: 600px">
                        <table id="tabelaIndicesModalMarkup" class="table table-sm table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </fieldset>
                  </div>
                  <div class="flex w-100 justify-content-center">
                    <div class="col-auto">
                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtTotalNacionalModalMarkup">Total Nacional:</label>
                      <input type="text" class="input-default focus form-control text-right" disabled id="txtTotalNacionalModalMarkup" name="txtTotalNacionalModalMarkup" placeholder="0,0000" style="min-width: 15ch; max-width: 20ch">
                    </div>
                    <div class="col-auto">
                      <label data-error="wrong" class="labelGeral" data-success="right" for="txtTotalExportacaoModalMarkup">Total Exportação:</label>
                      <input type="text" class="input-default focus form-control text-right" disabled id="txtTotalExportacaoModalMarkup" name="txtTotalExportacaoModalMarkup" placeholder="0,0000" style="min-width: 15ch; max-width: 20ch">
                    </div>
                  </div>
                </div>
                <div class="flex flex-wrap col-xl-6 col-12 align-content-start">
                  <div class="col-xl-12 col-12 px-0">
                    <fieldset class="border-Field my-0 p-0" style="padding-bottom: 5px!important;">
                      <legend class="textoBorda mb-0 py-0 text-md">Custos:</legend>
                      <div class="flex flex-wrap mx-1">
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="selectDiasModalMarkup">Dias:</label>
                          <div class="input-group">
                            <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectDiasModalMarkup" disabled aria-describedby="tipoError" class="custom-select focus">
                            </select>
                          </div>
                        </div>
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtTaxaModalMarkup">Taxa:</label>
                          <input type="text" class="input-default focus form-control text-right" disabled id="txtTaxaModalMarkup" name="txtTaxaModalMarkup" placeholder="0,00">
                        </div>
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarkupModalMarkup">Markup:</label>
                          <input type="text" class="input-default focus form-control text-right" disabled id="txtMarkupModalMarkup" name="txtMarkupModalMarkup" placeholder="0,00">
                        </div>
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtIndiceModalMarkup">Índice:</label>
                          <input type="text" class="input-default focus form-control text-right" disabled id="txtIndiceModalMarkup" name="txtIndiceModalMarkup" placeholder="0,00">
                        </div>
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarkupSemLucroModalMarkup">Markup sem lucro:</label>
                          <input type="text" class="input-default focus form-control text-right" disabled id="txtMarkupSemLucroModalMarkup" name="txtMarkupSemLucroModalMarkup" placeholder="0,00">
                        </div>
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtCustoModalMarkup">Custo:</label>
                          <input type="text" class="input-default focus form-control text-right" disabled id="txtCustoModalMarkup" name="txtCustoModalMarkup" placeholder="0,00">
                        </div>
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrecoAvistaModalMarkup">Preço à vista:</label>
                          <input type="text" class="input-default focus form-control text-right" disabled id="txtPrecoAvistaModalMarkup" name="txtPrecoAvistaModalMarkup" placeholder="0,00">
                        </div>
                        <div class="col-xl-3 col-6 form-group">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtCustoIndustrialModalMarkup">Custo Industrial:</label>
                          <input type="text" class="input-default focus form-control text-right quatroCasasDecimaisQuantityFormat" id="txtCustoIndustrialModalMarkup" name="txtCustoIndustrialModalMarkup" placeholder="0,0000">
                        </div>
                      </div>
                    </fieldset>
                  </div>
                  <div class="col-xl-6 col-12 pl-0">
                    <fieldset class="form d-flex border-Field my-0 p-0" style="padding-bottom: 5px!important">
                      <legend class="textoBorda mb-0 py-0 text-md">Prazo:</legend>
                      <div class="flex flex-wrap justify-content-between px-2 w-100">
                        <div class="d-flex flex-column col-4">
                          <span class="text-center text-md">Dias</span>
                          <input id="txtPrazoModalMarkup1" disabled class="inputInvisivel pr-1 d-none modalRowMarkup1 text-md" />
                          <input id="txtPrazoModalMarkup2" disabled class="inputInvisivel pr-1 d-none modalRowMarkup2 text-md" />
                          <input id="txtPrazoModalMarkup3" disabled class="inputInvisivel pr-1 d-none modalRowMarkup3 text-md" />
                          <input id="txtPrazoModalMarkup4" disabled class="inputInvisivel pr-1 d-none modalRowMarkup4 text-md" />
                          <input id="txtPrazoModalMarkup5" disabled class="inputInvisivel pr-1 d-none modalRowMarkup5 text-md" />
                          <input id="txtPrazoModalMarkup6" disabled class="inputInvisivel pr-1 d-none modalRowMarkup6 text-md" />
                          <input id="txtPrazoModalMarkup7" disabled class="inputInvisivel pr-1 d-none modalRowMarkup7 text-md" />
                        </div>
                        <div class="d-flex flex-column col-4">
                          <span class="text-center text-md">Preço</span>
                          <input id="txtPrecoModalMarkup1" disabled class="inputInvisivel pr-1 d-none modalRowMarkup1 text-md" />
                          <input id="txtPrecoModalMarkup2" disabled class="inputInvisivel pr-1 d-none modalRowMarkup2 text-md" />
                          <input id="txtPrecoModalMarkup3" disabled class="inputInvisivel pr-1 d-none modalRowMarkup3 text-md" />
                          <input id="txtPrecoModalMarkup4" disabled class="inputInvisivel pr-1 d-none modalRowMarkup4 text-md" />
                          <input id="txtPrecoModalMarkup5" disabled class="inputInvisivel pr-1 d-none modalRowMarkup5 text-md" />
                          <input id="txtPrecoModalMarkup6" disabled class="inputInvisivel pr-1 d-none modalRowMarkup6 text-md" />
                          <input id="txtPrecoModalMarkup7" disabled class="inputInvisivel pr-1 d-none modalRowMarkup7 text-md" />
                        </div>
                        <div class="d-flex flex-column col-4">
                          <span class="text-center text-md">Índice</span>
                          <input id="txtIndiceParcelaModalMarkup1" disabled class="inputInvisivel pr-1 d-none modalRowMarkup1 text-md" />
                          <input id="txtIndiceParcelaModalMarkup2" disabled class="inputInvisivel pr-1 d-none modalRowMarkup2 text-md" />
                          <input id="txtIndiceParcelaModalMarkup3" disabled class="inputInvisivel pr-1 d-none modalRowMarkup3 text-md" />
                          <input id="txtIndiceParcelaModalMarkup4" disabled class="inputInvisivel pr-1 d-none modalRowMarkup4 text-md" />
                          <input id="txtIndiceParcelaModalMarkup5" disabled class="inputInvisivel pr-1 d-none modalRowMarkup5 text-md" />
                          <input id="txtIndiceParcelaModalMarkup6" disabled class="inputInvisivel pr-1 d-none modalRowMarkup6 text-md" />
                          <input id="txtIndiceParcelaModalMarkup7" disabled class="inputInvisivel pr-1 d-none modalRowMarkup7 text-md" />
                        </div>
                      </div>
                    </fieldset>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-start">
            <button class="btn btnVerde btn-sisp" id="btnConfirmarModalMarkup">Confirmar</button>
            <button class="btn btn-danger btn-sisp" data-dismiss="modal" id="btnDesistirModalMarkup">Desistir</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade pr-0" data-backdrop="static" id="modalMediaConsumos">
      <div class="modal-dialog m-1" style="min-width: 99%;">
        <div class="modal-content" style="height: 100%" id="conteudoModalMediaConsumos">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloModalMediaConsumos"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body p-1 flex flex-wrap" style="height: 100%; max-height: 100% !important" id="modalMarkupBody">
            <div class="form-row col-12">
              <div class="d-flex flex-column col-12" style="height: 100%; max-height: 100%">
                <h5>Média Calculada</h5>
                <div class="table-responsive" style="max-height: 100%; overflow: hidden">
                  <table id="tabelaMediaConsumos" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="form-row col-7">
              <div class="d-flex flex-column col-12" style="height: 100%; max-height: 100%">
                <div class="table-responsive" style="max-height: 100%; overflow: hidden">
                  <table id="tabelaConferencia" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="form-row col-5">
              <div class="d-flex flex-column col-12" style="height: 100%; max-height: 100%">
                <div class="table-responsive" style="max-height: 100%; overflow: hidden">
                  <table id="tabelaConferenciaMaoDeObra" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between pt-0 align-items-end">
            <div class="flex align-items-end">
              <button class="btn btnVerde btn-sisp" id="btnConfirmarMediaConsumos" data-dismiss="modal" title="Clique para confirmar" style="max-height: 40px">Confirmar</button>
              <div class="d-flex justify-content-start mt-2 flex-wrap align-items-end">
                <div class="col-auto">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtTotalConsumoModalMediaConsumos">Total Consumo:</label>
                  <input type="text" class="input-default focus form-control text-right" disabled id="txtTotalConsumoModalMediaConsumos" name="txtTotalConsumoModalMediaConsumos" placeholder="0,0000">
                </div>
              </div>
            </div>
            <button class="btn btn-danger btn-sisp" id="btnFecharMediaConsumos" data-dismiss="modal" title="Clique para fechar">Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade pr-0" data-backdrop="static" id="modalAlteracao">
      <div class="modal-dialog m-1" style="min-width: 99%;">
        <div class="modal-content" style="height: 100%; min-height: 95vh; max-height: 95vh !important">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloModalAlteracao"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body p-1" style="height: 100%; max-height: 100% !important">
            <div class="form-row col-12">
              <div class="d-flex flex-column col-12" style="height: 100%; max-height: 100%">
                <div class="table-responsive" style="max-height: 100%; overflow: hidden">
                  <table id="tabelaItensAlteracao" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                  <table id="tabelaComposicaoAlteracao" class="table table-sm table-select table-hover d-none" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between pt-0 align-items-end">
            <div class="flex align-items-end w-100" style="gap: 8px">
              <button class="btn btnVerde btn-sisp" id="btnConfirmarAlteracao" title="Clique para confirmar" style="max-height: 40px">Confirmar</button>
              <button class="btn btn-primary btn-sisp" id="btnIncluirAlteracao" title="Clique para incluir" style="max-height: 40px">Incluir</button>
              <button class="btn btn-danger btn-sisp" id="btnExcluirAlteracao" title="Clique para excluir" style="max-height: 40px">Excluir</button>
              <div class="d-flex justify-content-start mt-2 flex-wrap align-items-end">
                <div class="col-auto">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtTotalCustoModalAlteracao">Total Custo:</label>
                  <input type="text" class="input-default focus form-control text-right" disabled id="txtTotalCustoModalAlteracao" name="txtTotalCustoModalAlteracao" placeholder="0,000000">
                </div>
              </div>
              <button class="btn btn-danger btn-sisp ml-auto" id="btnFecharAlteracao" data-dismiss="modal">Fechar</button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalComposicao" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="modalComposicao" aria-hidden="true">
      <div class="modal-dialog" style="min-width: 95%; min-height: 100%">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloModalComposicao"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="flex flex-wrap align-items-end mb-2" style="gap: 8px">
              <div class="col-xl-1 col-2 form-group d-none">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtOrdemComposicao">Ordem:</label>
                <input type="text" class="input-default focus form-control text-right quatroCasasDecimaisQuantityFormat disabledControl" disabled id="txtOrdemComposicao" name="txtOrdemComposicao" placeholder="0">
              </div>
              <div class="col-xl-1 col-2 form-group d-none">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtArtigoComposicao">Código:</label>
                <input type="text" class="input-default focus form-control text-right quatroCasasDecimaisQuantityFormat disabledControl" disabled id="txtArtigoComposicao" name="txtArtigoComposicao" placeholder="0">
              </div>
              <button class="btn btn-primary btn-sisp" id="btnIncluirItemComposicao">Incluir</button>
              <button class="btn btn-danger btn-sisp" id="btnExcluirItemComposicao">Excluir</button>
            </div>
            <div class="table-responsive" style="overflow-x: hidden">
              <table id="tabelaComposicao" class="table table-sm table-select table-hover" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
          <div class="modal-footer justify-content-between pt-0 align-items-end">
            <div class="flex align-items-end">
              <button class="btn btnVerde btn-sisp mr-auto" id="btnConfirmarModalComposicao"> Confirmar</button>
              <div class="d-flex justify-content-start mt-2 flex-wrap align-items-end">
                <div class="col-auto">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCustoTotalModalComposicao">Custo Total:</label>
                  <input type="text" class="input-default focus form-control text-right" disabled id="txtCustoTotalModalComposicao" name="txtCustoTotalModalComposicao" placeholder="0,000000">
                </div>
              </div>
            </div>
            <button class="btn btn-danger btn-sisp" data-dismiss="modal" id="btnFecharModalComposicao"> Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalFotoProduto" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="modalFotoProduto" aria-hidden="true">
      <div class="modal-dialog" style="min-width: 40%; min-height: 100%">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloModalFotoProduto"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="d-flex justify-content-center">
              <label id="btnEscolherFoto" for="imagemProduto" data-button="absolute" type="button">
                <img class="pop img img-fluid imagem" id="imagemProduto" src="../dist/img/prod-1.png" style="min-height: 400px">
              </label>
            </div>
          </div>
          <div class="modal-footer pt-0 align-items-end">
            <button class="btn btn-danger btn-sisp" data-dismiss="modal" id="btnFecharFotoProduto"> Fechar</button>
          </div>
        </div>
      </div>
    </div>
  </main>

  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  <script src="../plugins/jquery/jquery.min.js?versao=3.2511.28.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2511.28.1"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2511.28.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.2511.28.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2511.28.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.2511.28.1"></script>
  <script src="../utils/funcoes.js?versao=3.2511.28.1"></script>
  <script src="../utils/cookies.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.2511.28.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.2511.28.1"></script>
  <script src="https://cdn.datatables.net/select/1.6.0/js/dataTables.select.min.js"></script>
  <script src="../pages/formacao_custos/graficos.js?versao=3.2511.28.1"></script>
  <script src="https://code.highcharts.com/highcharts.js"></script>
  <script src="https://code.highcharts.com/highcharts-3d.js"></script>
  <script src="https://code.highcharts.com/modules/cylinder.js"></script>
  <script src="https://code.highcharts.com/modules/exporting.js"></script>
  <script src="https://code.highcharts.com/modules/export-data.js"></script>
  <script src="https://code.highcharts.com/modules/full-screen.js"></script>

  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('BAIXA_CONSUMOS');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/formacao_custos/cadastro_formacao_custos/formacao_custos.js?versao=3.2511.28.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>