$(document).ready(async function () {
  componenteFiltro('material', false, false, 'CodigoMaterial')
  componenteFiltro('cor', false, false, 'CorMaterial')
  componenteFiltro('deposito', false, false, 'DepositoMaterial')
  componenteFiltro('centroCusto', false, false, 'CentroCustoMaterial')
  componenteFiltro('contaContabil', false, false, 'ContaContabilMaterial')

  componenteFiltro('produto', false, false, 'CodigoProduto')
  componenteFiltro('cor', false, false, 'CorProduto')
  componenteFiltro('tamanho2', false, false, 'TamanhoProduto')
  componenteFiltro('deposito', false, false, 'DepositoProduto')
  componenteFiltro('centroCusto', false, false, 'CentroCustoProduto')
  componenteFiltro('contaContabil', false, false, 'ContaContabilProduto')

  componenteFiltro('servico', false, false, 'CodigoServico')
  componenteFiltro('centroCusto', false, false, 'CentroCustoServico')
  componenteFiltro('contaContabil', false, false, 'ContaContabilServico')

  $('.campoFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  $('#tabItens').on('click', () => setTimeout(
    () => $('#tabelaMateriaisManutencao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#tabProdutos').on('click', () => setTimeout(
    () => $('#tabelaProdutosManutencao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#tabServicos').on('click', () => setTimeout(
    () => $('#tabelaServicosManutencao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#btnAlterarMaterial').on('click', () => {
    const [indiceSelecionado] = $('#tabelaMateriaisManutencao').DataTable()?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      msgErro('Nenhum registro selecionado, impossível alterar.')
      return
    }
    habilitarAlteracaoMaterial()
  })

  $('#btnDesistirMaterial').on('click', () => {
    resetForm('#formMaterial')
    desabilitarAlteracaoMaterial()
  })

  $('#btnExcluirMaterial').on('click', () => excluirMaterial())

  $('#btnIncluirMaterial').on('click', () => {
    $('#tabelaMateriaisManutencao').DataTable().rows({ selected: true }).deselect()
    ModalManutencaoItensCompraCentralCompras.limparCamposMaterial()
    habilitarAlteracaoMaterial()
  })

  $('#txtQuantidadeMaterial, #txtPrecoMaterial').on('change', () => calcularValorItem({
    quantidade: $('#txtQuantidadeMaterial').val(),
    preco: $('#txtPrecoMaterial').val(),
    inputValor: '#txtValorMaterial'
  }))

  const habilitarAlteracaoMaterial = () => {
    $('.controleMaterialManutencao').prop('disabled', false)
    $('#btnAlterarMaterial').addClass('d-none')
    $('#btnExcluirMaterial').addClass('d-none')
    $('#btnIncluirMaterial').addClass('d-none')
    $('#btnConfirmarMaterial').removeClass('d-none')
    $('#btnDesistirMaterial').removeClass('d-none')
    $('#btnConfirmar').prop('disabled', true)
    $('#btnCancelar').prop('disabled', true)
  }

  const desabilitarAlteracaoMaterial = () => {
    $('.controleMaterialManutencao').prop('disabled', true)
    $('#btnAlterarMaterial').removeClass('d-none')
    $('#btnExcluirMaterial').removeClass('d-none')
    $('#btnIncluirMaterial').removeClass('d-none')
    $('#btnConfirmarMaterial').addClass('d-none')
    $('#btnDesistirMaterial').addClass('d-none')
    $('#btnConfirmar').prop('disabled', false)
    $('#btnCancelar').prop('disabled', false)
    const datatable = $('#tabelaMateriaisManutencao').DataTable()
    if (datatable.rows().count() === 0) {
      ModalManutencaoItensCompraCentralCompras.limparCamposMaterial()
      return
    }
    const [indiceSelecionado] = datatable?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      $('#tabelaMateriaisManutencao').DataTable().row(':first').select()
      return
    }
    const data = datatable.row(indiceSelecionado).data()
    ModalManutencaoItensCompraCentralCompras.preencherCamposMaterial(data)
  }

  const excluirMaterial = () => {
    const datatableMateriais = $('#tabelaMateriaisManutencao').DataTable()
    const [indice] = datatableMateriais?.rows({ selected: true }).indexes().toArray()
    datatableMateriais.row(indice).remove().draw(false)
    if (datatableMateriais.rows().count() > 0)
      datatableMateriais.row(':first').select()
    else
      ModalManutencaoItensCompraCentralCompras.limparCamposMaterial()
  }

  const confirmarMaterial = () => {
    const data = retornarDadosConfirmarMaterial()
    const datatableMateriais = $('#tabelaMateriaisManutencao').DataTable()
    const [indice] = datatableMateriais?.rows({ selected: true }).indexes().toArray()
    if (indice || indice === 0)
      alterarMaterial({
        datatable: datatableMateriais,
        data,
        indice,
      })
    else
      incluirMaterial({
        datatable: datatableMateriais,
        data,
      })
    desabilitarAlteracaoMaterial()
  }

  const alterarMaterial = ({ data, datatable, indice }) => {
    const datatableData = datatable.row(indice).data()
    datatable.row(indice).data({ ...datatableData, ...data }).draw(false)
  }

  const incluirMaterial = ({ datatable, data }) => datatable.row.add({ ...data, id: 0 }).draw(false)

  const retornarDadosConfirmarMaterial = () => {
    const material = retornarChaveDescricao('#txtCodigoMaterial')
    const cor = retornarChaveDescricao('#txtCorMaterial')
    const deposito = retornarChaveDescricao('#txtDepositoMaterial')
    const centroCusto = retornarChaveDescricao('#txtCentroCustoMaterial')
    const contaContabil = retornarChaveDescricao('#txtContaContabilMaterial')
    const especificacao = $('#txtEspecificacaoMaterial').val()
    const unidade = $('#txtUnidadeMaterial').val()
    const unidadeCompra = $('#txtUnidadeCompraMaterial').val()
    const fatorConversao = $('#txtFatorConversaoMaterial').val()
    const quantidade = $('#txtQuantidadeMaterial').val()
    const preco = $('#txtPrecoMaterial').val()
    const valor = $('#txtValorMaterial').val()

    return {
      codigo: material?.chave,
      descricao: material?.descricao,
      cor: cor?.chave,
      descricaoCor: cor?.descricao,
      tamanho: '',
      descricaoTamanho: '',
      deposito: deposito?.chave,
      descricaoDeposito: deposito?.descricao,
      centroCusto: centroCusto?.chave,
      descricaoCentroCusto: centroCusto?.descricao,
      contaContabil: contaContabil?.chave,
      descricaoContaContabil: contaContabil?.descricao,
      especificacao,
      unidade,
      unidadeCompra,
      fatorConversao,
      quantidade,
      preco,
      valor,
      tipoItem: 'M',
    }
  }

  $('#formMaterial').validate({
    rules: {
      codigo: {
        required: true,
      },
      cor: {
        required: true,
      },
      deposito: {
        required: true,
      },
      quantidade: {
        required: true,
      }
    },
    messages: {
      codigo: 'Material é obrigatório.',
      cor: 'Cor é obrigatória.',
      deposito: 'Depósito é obrigatório.',
      quantidade: 'Quantidade é obrigatória.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      confirmarMaterial()
    }
  })

  $('#btnAlterarProduto').on('click', () => {
    const [indiceSelecionado] = $('#tabelaProdutosManutencao').DataTable()?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      msgErro('Nenhum registro selecionado, impossível alterar.')
      return
    }
    habilitarAlteracaoProduto()
  })

  $('#btnDesistirProduto').on('click', () => {
    resetForm('#formProduto')
    desabilitarAlteracaoProduto()
  })

  $('#btnExcluirProduto').on('click', () => excluirProduto())

  $('#btnIncluirProduto').on('click', () => {
    $('#tabelaProdutosManutencao').DataTable().rows({ selected: true }).deselect()
    ModalManutencaoItensCompraCentralCompras.limparCamposProduto()
    habilitarAlteracaoProduto()
  })

  $('#txtQuantidadeProduto, #txtPrecoProduto').on('change', () => calcularValorItem({
    quantidade: $('#txtQuantidadeProduto').val(),
    preco: $('#txtPrecoProduto').val(),
    inputValor: '#txtValorProduto'
  }))

  const habilitarAlteracaoProduto = () => {
    $('.controleProdutoManutencao').prop('disabled', false)
    $('#btnAlterarProduto').addClass('d-none')
    $('#btnExcluirProduto').addClass('d-none')
    $('#btnIncluirProduto').addClass('d-none')
    $('#btnConfirmarProduto').removeClass('d-none')
    $('#btnDesistirProduto').removeClass('d-none')
    $('#btnConfirmar').prop('disabled', true)
    $('#btnCancelar').prop('disabled', true)
  }

  const desabilitarAlteracaoProduto = () => {
    $('.controleProdutoManutencao').prop('disabled', true)
    $('#btnAlterarProduto').removeClass('d-none')
    $('#btnExcluirProduto').removeClass('d-none')
    $('#btnIncluirProduto').removeClass('d-none')
    $('#btnConfirmarProduto').addClass('d-none')
    $('#btnDesistirProduto').addClass('d-none')
    $('#btnConfirmar').prop('disabled', false)
    $('#btnCancelar').prop('disabled', false)
    const datatable = $('#tabelaProdutosManutencao').DataTable()
    if (datatable.rows().count() === 0) {
      ModalManutencaoItensCompraCentralCompras.limparCamposProduto()
      return
    }
    const [indiceSelecionado] = datatable?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      $('#tabelaProdutosManutencao').DataTable().row(':first').select()
      return
    }
    const data = datatable.row(indiceSelecionado).data()
    ModalManutencaoItensCompraCentralCompras.preencherCamposProduto(data)
  }

  const excluirProduto = () => {
    const datatableProduto = $('#tabelaProdutosManutencao').DataTable()
    const [indice] = datatableProduto?.rows({ selected: true }).indexes().toArray()
    datatableProduto.row(indice).remove().draw(false)
    if (datatableProduto.rows().count() > 0)
      datatableProduto.row(':first').select()
    else
      ModalManutencaoItensCompraCentralCompras.limparCamposProduto()
  }

  const confirmarProduto = () => {
    const data = retornarDadosConfirmarProduto()
    const datatableProdutos = $('#tabelaProdutosManutencao').DataTable()
    const [indice] = datatableProdutos?.rows({ selected: true }).indexes().toArray()
    if (indice || indice === 0)
      alterarProduto({
        datatable: datatableProdutos,
        data,
        indice,
      })
    else
      incluirProduto({
        datatable: datatableProdutos,
        data,
      })
    desabilitarAlteracaoProduto()
  }

  const alterarProduto = ({ data, datatable, indice }) => {
    const datatableData = datatable.row(indice).data()
    datatable.row(indice).data({ ...datatableData, ...data }).draw(false)
  }

  const incluirProduto = ({ datatable, data }) => datatable.row.add({ ...data, id: 0 }).draw(false)

  const retornarDadosConfirmarProduto = () => {
    const produto = retornarChaveDescricao('#txtCodigoProduto')
    const cor = retornarChaveDescricao('#txtCorProduto')
    const tamanho = retornarChaveDescricao('#txtTamanhoProduto')
    const deposito = retornarChaveDescricao('#txtDepositoProduto')
    const centroCusto = retornarChaveDescricao('#txtCentroCustoProduto')
    const contaContabil = retornarChaveDescricao('#txtContaContabilProduto')
    const especificacao = $('#txtEspecificacaoProduto').val()
    const unidade = $('#txtUnidadeProduto').val()
    const unidadeCompra = $('#txtUnidadeCompraProduto').val()
    const quantidade = $('#txtQuantidadeProduto').val()
    const preco = $('#txtPrecoProduto').val()
    const valor = $('#txtValorProduto').val()

    return {
      codigo: produto?.chave,
      descricao: produto?.descricao,
      cor: cor?.chave,
      descricaoCor: cor?.descricao,
      tamanho: tamanho?.chave,
      descricaoTamanho: tamanho?.descricao,
      deposito: deposito?.chave,
      descricaoDeposito: deposito?.descricao,
      centroCusto: centroCusto?.chave,
      descricaoCentroCusto: centroCusto?.descricao,
      contaContabil: contaContabil?.chave,
      descricaoContaContabil: contaContabil?.descricao,
      especificacao,
      unidade,
      unidadeCompra,
      fatorConversao: '',
      quantidade,
      preco,
      valor,
      tipoItem: 'P',
    }
  }

  $('#formProduto').validate({
    rules: {
      codigo: {
        required: true,
      },
      cor: {
        required: true,
      },
      tamanho: {
        required: true,
      },
      deposito: {
        required: true,
      },
      quantidade: {
        required: true,
      }
    },
    messages: {
      codigo: 'Produto é obrigatório.',
      cor: 'Cor é obrigatória.',
      tamanho: 'Tamanho é obrigatório.',
      deposito: 'Depósito é obrigatório.',
      quantidade: 'Quantidade é obrigatória.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      confirmarProduto()
    }
  })

  $('#btnAlterarServico').on('click', () => {
    const [indiceSelecionado] = $('#tabelaServicosManutencao').DataTable()?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      msgErro('Nenhum registro selecionado, impossível alterar.')
      return
    }
    habilitarAlteracaoServico()
  })

  $('#btnDesistirServico').on('click', () => {
    resetForm('#formServico')
    desabilitarAlteracaoServico()
  })

  $('#btnExcluirServico').on('click', () => excluirServico())

  $('#btnIncluirServico').on('click', () => {
    $('#tabelaServicosManutencao').DataTable().rows({ selected: true }).deselect()
    ModalManutencaoItensCompraCentralCompras.limparCamposServico()
    habilitarAlteracaoServico()
  })

  $('#txtQuantidadeServico, #txtPrecoServico').on('change', () => calcularValorItem({
    quantidade: $('#txtQuantidadeServico').val(),
    preco: $('#txtPrecoServico').val(),
    inputValor: '#txtValorServico'
  }))

  const habilitarAlteracaoServico = () => {
    $('.controleServicoManutencao').prop('disabled', false)
    $('#btnAlterarServico').addClass('d-none')
    $('#btnExcluirServico').addClass('d-none')
    $('#btnIncluirServico').addClass('d-none')
    $('#btnConfirmarServico').removeClass('d-none')
    $('#btnDesistirServico').removeClass('d-none')
    $('#btnConfirmar').prop('disabled', true)
    $('#btnCancelar').prop('disabled', true)
  }

  const desabilitarAlteracaoServico = () => {
    $('.controleServicoManutencao').prop('disabled', true)
    $('#btnAlterarServico').removeClass('d-none')
    $('#btnExcluirServico').removeClass('d-none')
    $('#btnIncluirServico').removeClass('d-none')
    $('#btnConfirmarServico').addClass('d-none')
    $('#btnDesistirServico').addClass('d-none')
    $('#btnConfirmar').prop('disabled', false)
    $('#btnCancelar').prop('disabled', false)
    const datatable = $('#tabelaServicosManutencao').DataTable()
    if (datatable.rows().count() === 0) {
      ModalManutencaoItensCompraCentralCompras.limparCamposServico()
      return
    }
    const [indiceSelecionado] = datatable?.rows({ selected: true })?.indexes()?.toArray()
    if (!indiceSelecionado && indiceSelecionado !== 0) {
      $('#tabelaServicosManutencao').DataTable().row(':first').select()
      return
    }
    const data = datatable.row(indiceSelecionado).data()
    ModalManutencaoItensCompraCentralCompras.preencherCamposServico(data)
  }

  const excluirServico = () => {
    const datatableServico = $('#tabelaServicosManutencao').DataTable()
    const [indice] = datatableServico?.rows({ selected: true }).indexes().toArray()
    datatableServico.row(indice).remove().draw(false)
    if (datatableServico.rows().count() > 0)
      datatableServico.row(':first').select()
    else
      ModalManutencaoItensCompraCentralCompras.limparCamposServico()
  }

  const confirmarServico = () => {
    const data = retornarDadosConfirmarServico()
    const datatableServicos = $('#tabelaServicosManutencao').DataTable()
    const [indice] = datatableServicos?.rows({ selected: true }).indexes().toArray()
    if (indice || indice === 0)
      alterarServico({
        datatable: datatableServicos,
        data,
        indice,
      })
    else
      incluirServico({
        datatable: datatableServicos,
        data,
      })
    desabilitarAlteracaoServico()
  }

  const alterarServico = ({ data, datatable, indice }) => {
    const datatableData = datatable.row(indice).data()
    datatable.row(indice).data({ ...datatableData, ...data }).draw(false)
  }

  const incluirServico = ({ datatable, data }) => datatable.row.add({ ...data, id: 0 }).draw(false)

  const retornarDadosConfirmarServico = () => {
    const servico = retornarChaveDescricao('#txtCodigoServico')
    const centroCusto = retornarChaveDescricao('#txtCentroCustoServico')
    const contaContabil = retornarChaveDescricao('#txtContaContabilServico')
    const especificacao = $('#txtEspecificacaoServico').val()
    const quantidade = $('#txtQuantidadeServico').val()
    const preco = $('#txtPrecoServico').val()
    const valor = $('#txtValorServico').val()

    return {
      codigo: servico?.chave,
      descricao: servico?.descricao,
      cor: '',
      descricaoCor: '',
      tamanho: '',
      descricaoTamanho: '',
      deposito: '',
      descricaoDeposito: '',
      centroCusto: centroCusto?.chave,
      descricaoCentroCusto: centroCusto?.descricao,
      contaContabil: contaContabil?.chave,
      descricaoContaContabil: contaContabil?.descricao,
      especificacao,
      unidade: '',
      unidadeCompra: '',
      fatorConversao: '',
      quantidade,
      preco,
      valor,
      tipoItem: 'S',
    }
  }

  $('#formServico').validate({
    rules: {
      codigo: {
        required: true,
      },
      quantidade: {
        required: true,
      }
    },
    messages: {
      codigo: 'Serviço é obrigatório.',
      quantidade: 'Quantidade é obrigatória.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      confirmarServico()
    }
  })

  const calcularValorItem = ({ quantidade, preco, inputValor }) => {
    if (!quantidade) {
      $('#txtValorMaterial').val('0.00')
      return
    }
    if (!preco) {
      $('#txtValorMaterial').val('0.00')
      return
    }

    const valor = (parseFloat(quantidade) * parseFloat(preco)).toFixed(2)
    $(inputValor).val(valor)
  }

  $('#btnConfirmar').on('click', () => {
    msgAlerta(
      'Deseja gravar os dados?',
      () => null,
      () => null,
      () => {
        const dados = retornarDadosConfirmar()
        if (!validarDadosConfirmar(dados)) return
        confirmar(dados)
      }
    )
  })

  const validarDadosConfirmar = ({ itens }) => {
    if (!itens || !itens.length || itens.length === 0) {
      msgErro('Nenhum item informado, impossível continuar.')
      return false
    }

    return true
  }

  const confirmar = (dados) => {
    $.LoadingOverlay('show')
    requisicao(
      'PUT',
      `/sisplan/centralcompras/compra/v1/itens?`,
      '',
      JSON.stringify(dados),
      3600000
    ).then(async (response) => {
      const json = await response.json()
      if (json) {
        const { mensagem, resultado } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            const { App } = ModalManutencaoItensCompraCentralCompras
            const id = safeParseInt($('#txtIdCapa').val()) ?? 0
            App.consultar(id)
            $('#modalManutencaoItens').modal('hide')
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const retornarDadosConfirmar = () => {
    const itens = [
      ...$('#tabelaMateriaisManutencao').DataTable().data().toArray(),
      ...$('#tabelaProdutosManutencao').DataTable().data().toArray(),
      ...$('#tabelaServicosManutencao').DataTable().data().toArray(),
    ]

    const idCompra = $('#txtIdCapa').val()
    const numero = $('#txtNumeroCapa').val()

    return {
      itens,
      idCompra,
      numero,
    }
  }

  const resetForm = (formSelector) => {
    $(formSelector)[0].reset()
    const validator = $(formSelector).validate()
    validator.resetForm()
    $(formSelector)
      .find('.error')
      .removeClass('error')
  }

  $('#modalManutencaoItens').on('shown.bs.modal', () => ModalManutencaoItensCompraCentralCompras.carregarApp($('#selectStatus').val()))

  $('#modalManutencaoItens').on('hide.bs.modal', () => {
    ModalManutencaoItensCompraCentralCompras.limparModal()
    $('#tabMateriais').tab('show')
  })
})

window.ModalManutencaoItensCompraCentralCompras = window.ModalManutencaoItensCompraCentralCompras || {}

ModalManutencaoItensCompraCentralCompras.App = null

ModalManutencaoItensCompraCentralCompras.carregarApp = (status) => {
  ModalManutencaoItensCompraCentralCompras.App = ItensCompra
  return
  switch (status) {
    case 'D':
      ModalManutencaoItensCompraCentralCompras.App = ItensCompraDigitados
      break
    case 'N':
      ModalManutencaoItensCompraCentralCompras.App = ItensCompraRetornados
      break
    default:
      break
  }
}

ModalManutencaoItensCompraCentralCompras.limparModal = () => {
  ModalManutencaoItensCompraCentralCompras.limparCamposMaterial()
  ModalManutencaoItensCompraCentralCompras.limparCamposProduto()
  ModalManutencaoItensCompraCentralCompras.limparCamposServico()
  if ($.fn.DataTable.isDataTable('#tabelaMateriaisManutencao')) {
    $('#tabelaMateriaisManutencao').DataTable().destroy()
    $('#tabelaMateriaisManutencao').empty()
  }
}

ModalManutencaoItensCompraCentralCompras.carregarModalManutencao = (dadosEditar, situacao, idCapa, numero) => {
  ModalManutencaoItensCompraCentralCompras.preencherDadosModalEditar(dadosEditar)
  $('#selectStatus').val(situacao)
  $('#txtIdCapa').val(idCapa)
  $('#txtNumeroCapa').val(numero)
  $('#modalManutencaoItens').modal('show')
  setTimeout(
    () => $('#tabelaMateriaisManutencao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  )
}

ModalManutencaoItensCompraCentralCompras.preencherDadosModalEditar = (dados) => {
  const materiais = []
  const produtos = []
  const servicos = []
  dados.forEach((item) => {
    switch (item.tipoItem) {
      case 'M':
        materiais.push(item)
        break
      case 'P':
        produtos.push(item)
        break
      case 'S':
        servicos.push(item)
        break
      default:
        break
    }
  })
  ModalManutencaoItensCompraCentralCompras.criarTabelaMateriaisManutencao(materiais)
  ModalManutencaoItensCompraCentralCompras.criarTabelaProdutosManutencao(produtos)
  ModalManutencaoItensCompraCentralCompras.criarTabelaServicosManutencao(servicos)
}

ModalManutencaoItensCompraCentralCompras.limparCamposMaterial = () => $('.camposMaterialManutencao').val('')

ModalManutencaoItensCompraCentralCompras.preencherCamposMaterial = (dados) => {
  if (!dados) return
  dados.codigo ? insereValor('#txtCodigoMaterial', dados.codigo, dados.descricao) : $('#txtCodigoMaterial').val('')
  dados.cor ? insereValor('#txtCorMaterial', dados.cor, dados.descricaoCor) : $('#txtCorMaterial').val('')
  dados.deposito ? insereValor('#txtDepositoMaterial', dados.deposito, dados.descricaoDeposito) : $('#txtDepositoMaterial').val('')
  dados.centroCusto ? insereValor('#txtCentroCustoMaterial', dados.centroCusto, dados.descricaoCentroCusto) : $('#txtCentroCustoMaterial').val('')
  dados.contaContabil ? insereValor('#txtContaContabilMaterial', dados.contaContabil, dados.descricaoContaContabil) : $('#txtContaContabilMaterial').val('')
  dados.especificacao ? insereValor('#txtEspecificacaoMaterial', dados.especificacao) : $('#txtEspecificacaoMaterial').val('')
  dados.unidade ? insereValor('#txtUnidadeMaterial', dados.unidade) : $('#txtUnidadeMaterial').val('')
  dados.unidadeCompra ? insereValor('#txtUnidadeCompraMaterial', dados.unidadeCompra) : $('#txtUnidadeMaterial').val('')
  dados.fatorConversao ? insereValor('#txtFatorConversaoMaterial', parseFloat(dados.fatorConversao).toFixed(2)) : $('#txtFatorConversaoMaterial').val('0.00')
  dados.quantidade ? insereValor('#txtQuantidadeMaterial', parseFloat(dados.quantidade).toFixed(2)) : $('#txtQuantidadeMaterial').val('0.00')
  dados.preco ? insereValor('#txtPrecoMaterial', parseFloat(dados.preco).toFixed(2)) : $('#txtPrecoMaterial').val('0.00')
  insereValor('#txtValorMaterial', parseFloat(dados.valor).toFixed(2))
}

ModalManutencaoItensCompraCentralCompras.criarTabelaMateriaisManutencao = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaMateriaisManutencao')) {
    $('#tabelaMateriaisManutencao').DataTable().destroy()
    $('#tabelaMateriaisManutencao').empty()
  }

  const columns = [
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
      visible: false,
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
      visible: false,
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  const table = $('#tabelaMateriaisManutencao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '250px',
    select: {
      style: 'single',
      toggleable: false,
    },
  })
  table.off('select')
  table.on('select', function (_e, _dt, type, indexes) {
    if (type === 'row') {
      const [data] = table.rows(indexes[0]).data().toArray()
      ModalManutencaoItensCompraCentralCompras.preencherCamposMaterial(data)
    }
  })
  $('#tabelaMateriaisManutencao').DataTable().row(':first').select()
}

ModalManutencaoItensCompraCentralCompras.limparCamposProduto = () => $('.camposProdutoManutencao').val('')

ModalManutencaoItensCompraCentralCompras.preencherCamposProduto = (dados) => {
  if (!dados) return
  dados.codigo ? insereValor('#txtCodigoProduto', dados.codigo, dados.descricao) : $('#txtCodigoProduto').val('')
  dados.cor ? insereValor('#txtCorProduto', dados.cor, dados.descricaoCor) : $('#txtCorProduto').val('')
  dados.tamanho ? insereValor('#txtTamanhoProduto', dados.tamanho, dados.descricaoTamanho) : $('#txtTamanhoProduto').val('')
  dados.deposito ? insereValor('#txtDepositoProduto', dados.deposito, dados.descricaoDeposito) : $('#txtDepositoProduto').val('')
  dados.centroCusto ? insereValor('#txtCentroCustoProduto', dados.centroCusto, dados.descricaoCentroCusto) : $('#txtCentroCustoProduto').val('')
  dados.contaContabil ? insereValor('#txtContaContabilProduto', dados.contaContabil, dados.descricaoContaContabil) : $('#txtContaContabilProduto').val('')
  dados.especificacao ? insereValor('#txtEspecificacaoProduto', dados.especificacao) : $('#txtEspecificacaoProduto').val('')
  dados.unidade ? insereValor('#txtUnidadeProduto', dados.unidade) : $('#txtUnidadeProduto').val('')
  dados.unidadeCompra ? insereValor('#txtUnidadeCompraProduto', dados.unidadeCompra) : $('#txtUnidadeProduto').val('')
  dados.quantidade ? insereValor('#txtQuantidadeProduto', parseFloat(dados.quantidade).toFixed(2)) : $('#txtQuantidadeProduto').val('0.00')
  dados.preco ? insereValor('#txtPrecoProduto', parseFloat(dados.preco).toFixed(2)) : $('#txtPrecoProduto').val('0.00')
  insereValor('#txtValorProduto', parseFloat(dados.valor).toFixed(2))
}

ModalManutencaoItensCompraCentralCompras.criarTabelaProdutosManutencao = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaProdutosManutencao')) {
    $('#tabelaProdutosManutencao').DataTable().destroy()
    $('#tabelaProdutosManutencao').empty()
  }

  const columns = [
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      visible: false,
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
      visible: false,
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  const table = $('#tabelaProdutosManutencao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '250px',
    select: {
      style: 'single',
      toggleable: false,
    },
  })
  table.off('select')
  table.on('select', function (_e, _dt, type, indexes) {
    if (type === 'row') {
      const [data] = table.rows(indexes[0]).data().toArray()
      ModalManutencaoItensCompraCentralCompras.preencherCamposProduto(data)
    }
  })
  $('#tabelaProdutosManutencao').DataTable().row(':first').select()
}

ModalManutencaoItensCompraCentralCompras.limparCamposServico = () => $('.camposServicoManutencao').val('')

ModalManutencaoItensCompraCentralCompras.preencherCamposServico = (dados) => {
  if (!dados) return
  dados.codigo ? insereValor('#txtCodigoServico', dados.codigo, dados.descricao) : $('#txtCodigoServico').val('')
  dados.centroCusto ? insereValor('#txtCentroCustoServico', dados.centroCusto, dados.descricaoCentroCusto) : $('#txtCentroCustoServico').val('')
  dados.contaContabil ? insereValor('#txtContaContabilServico', dados.contaContabil, dados.descricaoContaContabil) : $('#txtContaContabilServico').val('')
  dados.especificacao ? insereValor('#txtEspecificacaoServico', dados.especificacao) : $('#txtEspecificacaoServico').val('')
  dados.quantidade ? insereValor('#txtQuantidadeServico', parseFloat(dados.quantidade).toFixed(2)) : $('#txtQuantidadeServico').val('0.00')
  dados.preco ? insereValor('#txtPrecoServico', parseFloat(dados.preco).toFixed(2)) : $('#txtPrecoServico').val('0.00')
  insereValor('#txtValorServico', parseFloat(dados.valor).toFixed(2))
}

ModalManutencaoItensCompraCentralCompras.criarTabelaServicosManutencao = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaServicosManutencao')) {
    $('#tabelaServicosManutencao').DataTable().destroy()
    $('#tabelaServicosManutencao').empty()
  }

  const columns = [
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
      visible: false,
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
      visible: false,
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
      visible: false,
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
      visible: false,
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
      visible: false,
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
      visible: false,
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
      visible: false,
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      visible: false,
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
      visible: false,
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  const table = $('#tabelaServicosManutencao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '250px',
    select: {
      style: 'single',
      toggleable: false,
    },
  })
  table.off('select')
  table.on('select', function (_e, _dt, type, indexes) {
    if (type === 'row') {
      const [data] = table.rows(indexes[0]).data().toArray()
      ModalManutencaoItensCompraCentralCompras.preencherCamposServico(data)
    }
  })
  $('#tabelaServicosManutencao').DataTable().row(':first').select()
}