$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoPrazo',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um prazo.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaPrazo',
                popover: {
                    title: 'Tabela Prazos',
                    description: 'Aqui estão os dados dos prazos cadastrados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CADPRAZO");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoPrazo').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadprazo/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnCodigo').pesquisa('#txtCodigo', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["DESCRICAO", "PRAZO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btnACodigo').on('click', function () {
        $('#txtCodigo').val('');
    });

    $('#btnDistSemana').on('click', function () {
        $('#modal-dist-semana').modal('show');
    })

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '     <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '     <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    await consultaPrazo();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaPrazo();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtCodigo').val('');
    });

    $('#btnDistSemana-Processar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            const dtIni = $('#dtIni').val()
            const dtFim = $('#dtFim').val()
            const dias = $('#inptDias').val()
            const smtDiaUtil = $('#cbDiaUtil').is(':checked')

            const semanas = await processaDias({
                prazoIni: dtIni, 
                prazoFim: dtFim, 
                dias, 
                somenteDiaUtil: smtDiaUtil
            })

            alimentaTabelaModal(semanas)

            $('#btnModalConfirmar').prop('disabled', false)
            $('#btnModalDesistir').prop('disabled', false)
        } catch (error) {
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnModalConfirmar').on('click', function () {
        msgAguardaConfirmacao(
            'Tem certeza que deseja gravar os dados informados?',
            ()=>{inserirValores()},
            ()=>{}
        )
    })

    async function consultaPrazo() {
        try {
            $.LoadingOverlay("show");
            let codigo = pegaChave('#txtCodigo') != '' ? `AND PRAZO = '${pegaChave('#txtCodigo')}'` : '';
            const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"], "where": ["1=1 ${codigo}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadPrazo == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadPrazo: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaPrazo').DataTable({
                destroy: true,
                lengthChange: true,
                paging: true,
                searching: true,
                scrollX: true,
                scrollY: '350px',
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [
                    { data: "PRAZO", title: "Prazo" },
                    { data: "DESCRICAO", title: "Descrição" },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $('#tabelaPrazo_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaPrazo_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaPrazo").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Prazo', '', '', 999, false, false, dados);
            });

            $('#tabelaPrazo').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadPrazo).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaPrazo').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadPrazo ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["PRAZO"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadPrazo: novasColunas }));

            $('#tabelaPrazo').DataTable().columns().visible(true);

            $('#tabelaPrazo').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaPrazo').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaPrazo').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CADPRAZO', data.PRAZO);
            if (registroLiberado) {
                window.location.href = `cadprazo/${data.PRAZO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaPrazo').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaPrazo').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('CADPRAZO', data.PRAZO);
            if (registroLiberado) {
                window.location.href = `cadprazo/${data.PRAZO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaPrazo').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaPrazo").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", '/sisplan/cadastros/v1/cadprazo?', `PRAZO=${(valorLinha.PRAZO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function processaDias({
        dias,
        prazoIni,
        prazoFim,
        iniciaSemanaIndex = 0,
        somenteDiaUtil = false
    }) {
        const semanas = [];

        if (dias <= 0 || !validarDataSqlFn(prazoIni) || !validarDataSqlFn(prazoFim)) {
            throw new Error("Dados inválidos. Impossível continuar.");
        }

        const dataInicio = parseDateLocal(prazoIni);
        const dataFim = parseDateLocal(prazoFim);

        if (dataInicio > dataFim) {
            throw new Error("Data de início não pode ser maior que a data de fim.");
        }

        let dia = new Date(dataInicio);

        if (somenteDiaUtil) {
            while (!pesquisaDiaUtil(dia) && dia <= dataFim) {
                dia = incDia(dia, 1);
            }
        }

        while (dia <= dataFim) {
            let semanaNumero = weekOfYearFn(dia);
            let anoAtual = dia.getFullYear().toString().slice(2);
            
            if (iniciaSemanaIndex === 1) {
                const semanasTotais = weeksInYearFn(dia.getFullYear());
                
                if (dia.getMonth() === 11 && semanaNumero === semanasTotais) {
                    const proximoAno = dia.getFullYear() + 1;
                    anoAtual = proximoAno.toString().slice(2);
                    semanaNumero = 1;
                }
            }

            let semanaStr = semanaNumero.toString().padStart(2, "0");

            let i = 1;
            while (semanas.find(s => s.Prazo === anoAtual + semanaStr)) {
                semanaStr = (semanaNumero + i).toString().padStart(2, "0");
                i++;
            }

            let inicio = new Date(dia);
            let fim = new Date(dia);

            if (somenteDiaUtil) {
                let diasAdicionados = 0;
                let dataTemp = new Date(dia);
                
                while (diasAdicionados < dias && dataTemp <= dataFim) {
                    dataTemp = incDia(dataTemp, 1);
                    if (pesquisaDiaUtil(dataTemp)) {
                        diasAdicionados++;
                    }
                }
                fim = dataTemp;
            } else {
                fim = incDia(dia, dias);
                
                if (fim > dataFim) {
                    fim = new Date(dataFim);
                }
            }

            semanas.push({
                Prazo: anoAtual + semanaStr,
                Descricao: `SEMANA ${anoAtual + semanaStr} (${formatDate(inicio)} - ${formatDate(fim)})`,
                Inicio: inicio,
                Fim: fim
            });

            dia = incDia(fim, 1);
            
            if (somenteDiaUtil) {
                while (!pesquisaDiaUtil(dia) && dia <= dataFim) {
                    dia = incDia(dia, 1);
                }
            }

            if (dia > dataFim) {
                break;
            }
        }

        return semanas;
    }

    function incDia(date, n) {
        const d = new Date(date);
        d.setDate(d.getDate() + n);
        return d;
    }

    function formatDate(date) {
        return date.toLocaleDateString("pt-BR");
    }

    function parseDateLocal(dateStr) {
        const [ano, mes, dia] = dateStr.split("-").map(Number);
        return new Date(ano, mes - 1, dia);
    }

    function weekOfYearFn(date) {
        const tmp = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate()));
        const dayNum = tmp.getUTCDay() || 7;

        tmp.setUTCDate(tmp.getUTCDate() + 4 - dayNum);

        const yearStart = new Date(Date.UTC(tmp.getUTCFullYear(), 0, 1));
        return Math.ceil((((tmp - yearStart) / 86400000) + 1) / 7);
    }

    function weeksInYearFn(year) {
        const d = new Date(Date.UTC(year, 0, 1));
        const day = d.getUTCDay() || 7;

        // ano ISO-8601 com 53 semanas
        if (day <= 4) return 53;

        return 52;
    }

    function validarDataSqlFn(dt) {
        if (
            dt !== 0 && 
            dt !== '01/01/1200' && dt !== '31/12/2500' && 
            dt !== '01/01/1980' && dt !== '31/12/2050'
        ) {
            return true
        }
        return false
    }

    function alimentaTabelaModal(semanas) {
        const dadosConvertidos = semanas.map(semana => ({
            PRAZO: semana.Prazo,
            DESCRICAO: semana.Descricao,
            DTINI: formatDate(semana.Inicio),
            DTFIM: formatDate(semana.Fim)
        }));

        $('#tabDistSem').DataTable({
            destroy: true,
            lengthChange: true,
            paging: true,
            searching: true,
            scrollX: true,
            pageLength: 10,
            scrollY: '300px',
            autoWidth: true,
            data: dadosConvertidos,
            columns: [
                { data: "PRAZO", title: "Prazo" },
                { data: "DESCRICAO", title: "Descrição" },
                { data: "DTINI", title: "Data Início" },
                { data: "DTFIM", title: "Data Fim" }
            ],
            language: {
                url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/pt-BR.json' // Opcional: tradução PT-BR
            }
        });
    }
    
    async function inserirValores() {
        $.LoadingOverlay('show')
        try {
            const tabela = $('#tabDistSem').DataTable();
            const valores = tabela.rows().data().toArray();

            for (let i = 0; i < valores.length; i++) {
                const ATIVO_PRODUCAO = $('#cbAtivoPro').is(':checked') ? 'S' : 'N'
                const BLOQ_VENDA = $('#cbBloqVenda').is(':checked') ? 'S' : 'N'



                const obj = {
                    PRAZO: valores[i].PRAZO,
                    DESCRICAO: valores[i].DESCRICAO.toUpperCase(),
                    DT_INICIO: formataDataParaSql(valores[i].DTINI),
                    DT_FIM: formataDataParaSql(valores[i].DTFIM),
                    ATIVO_PRODUCAO, BLOQ_VENDA
                }

                let response = await requisicao('POST', '/sisplan/cadastros/v1/cadprazo?', '', `JSON=${JSON.stringify(obj)}`, 15000);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    'Cadastro efetuado com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/cadprazo`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            }
        } catch (error) {
            msgAlerta('Houve um erro ao realizar o cadastro, tente novamente.')
        }
    }

    function formataDataParaSql(dataBR) {
        if (!dataBR) return null;

        const partes = dataBR.split('/');
        if (partes.length !== 3) return null;

        const [dia, mes, ano] = partes;

        const dd = dia.padStart(2, '0');
        const mm = mes.padStart(2, '0');
        const yyyy = ano;

        return `${yyyy}-${mm}-${dd}T00:00:00Z`;
    }

});