<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Comissão</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.28.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link href='dist/css/bootstrap.min.css?versao=3.2511.28.1'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.28.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.28.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.28.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="dist/css/cadastro.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.28.1">
  <style>
    #tabelaComissoes td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaComissoes td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    /* #tabelaOs_wrapper .table.dataTable tbody td {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    } */


    .btnSuccess {
      background-color: #25d366 !important;
      border-color: #25d366 !important;
      color: #fff;
    }

    .btnSuccess:hover {
      background-color: #20ae59 !important;
      border-color: #20ae59 !important;
      color: #fff;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cadastro de Comissão</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
          </div>
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <div class="row">
                <div class="col-sm-6 col-md-6 col-6">
                  <div class="row col-12">
                    <div class="col-md-12 d-flex justify-content-start">
                      <button class="btn btn-success btn-sisp mr-1" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                      <button class="btn btn-danger btn-sisp mr-1" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
                      <button class="btn btn-secondary btn-sisp" id="btnImprimir"><span class="fas fa-print pr-1" style="color: white!important"></span> Imprimir</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Comissões</h5>
              <table id="tabelaComissoes" class="table table-sm-sisp table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Id</th>
                    <th class="th-sm">Sequência</th>
                    <th class="th-sm">Código</th>
                    <th class="th-sm">Descrição Item</th>
                    <th class="th-sm">Desc. De</th>
                    <th class="th-sm">Desc. Até</th>
                    <th class="th-sm">Comissão</th>
                    <th class="th-sm">Tipo</th>
                    <th class="th-sm">Representante</th>
                    <th class="th-sm">Nome Representante</th>
                    <th class="th-sm">Tab. Preço</th>
                    <th class="th-sm">Descrição Tab. Preço</th>
                    <th class="th-sm">Desconto</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">

                <div class="col-4" id="ProdutoInfoTour">
                  <label data-error="wrong" data-success="right" for="txtProduto">Produto: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaProduto" name="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-4 d-none" id="MaterialInfoTour">
                  <label data-error="wrong" data-success="right" for="txtMaterial">Material: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMaterial" name="txtMaterial" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMaterial" name="btnMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMaterial" name="btnLimpaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-4" id="RepresentanteInfoTour">
                  <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtRepresentante" name="txtRepresentante" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaRepresentante" name="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-sm-2 col-2 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtComissaoDe">% Comissão de/até: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control validate text-right" value="0" id="txtComissaoDe" name="txtComissaoDe">
                    <input type="text" class="input-default focus form-control validate text-right" value="0" id="txtComissaoAte" name="txtComissaoAte">
                  </div>
                </div>

                <div class="col-sm-2 col-2 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorDe">Valores de/até</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control validate text-right" value="0" id="txtValorDe" name="txtValorDe">
                    <input type="text" class="input-default focus form-control validate text-right" value="0" id="txtValorAte" name="txtValorAte">
                  </div>
                </div>

                <div class="col-4 form-group" id="TabelaPrecoInfoTour">
                  <label data-error="wrong" data-success="right" for="txtTabPreco">Tabela de Preço: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtTabPreco" name="txtTabPreco" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTabPreco" name="btnTabPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTabPreco" name="btnLimpaTabPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-3 col-sm-3 col-3 mt-3">
                  <div class="form" id="area">
                    <fieldset class="form border-Field">
                      <legend class="textoBorda mb-0 pb-0">Tipo</legend>
                      <div class="form-row ml-auto justify-content-left">
                        <div class="icheck-primary form-group form-check pl-2">
                          <input type="radio" id="rdProduto" checked name="rdTipo" class='rdTipo' value="P">
                          <label class="labelCheck" for="rdProduto">Produto</label>
                        </div>
                        <div class="icheck-primary form-group form-check pl-2">
                          <input type="radio" id="rdMaterial" name="rdTipo" class='rdTipo' value="M">
                          <label class="labelCheck" for="rdMaterial">Material</label>
                        </div>
                      </div>
                    </fieldset>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.28.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.28.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.28.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2511.28.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2511.28.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2511.28.1"></script>
  <script src="utils/funcoes.js?versao=3.2511.28.1"></script>
  <script src="utils/cookies.js?versao=3.2511.28.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2511.28.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2511.28.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2511.28.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2511.28.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.2511.28.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2511.28.1"></script>

  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CADCOMISSAO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/cadcomissao/acesso_cadcomissao/acesso_cadcomissao.js?versao=3.2511.28.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>

</body>

</html>