$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#divTabelaConsumos',
        popover: {
          title: 'Consumos',
          description: 'Aqui se encontram os consumos da ordem de produção informada.',
          position: 'top'
        }
      },
      {
        element: '#txtBarra',
        popover: {
          title: 'Barra',
          description: 'Aqui é possível fazer a baixa bipando uma barra de material.',
          position: 'top'
        }
      },
      {
        element: '#tabLotes',
        popover: {
          title: 'Estoque/Reserva',
          description: 'Aqui se encontram os lotes em estoque/reserva disponíveis.',
          position: 'top'
        }
      },
      {
        element: '#tabBaixas',
        popover: {
          title: 'Baixas',
          description: 'Aqui se encontram as baixas realizadas para a ordem de produção informada.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $("#btnConfirmarBarra").prop("disabled", true);
  let filtroAplicado = false;

  let tabelaConsumos = false;
  let tabelaEstRes = false;
  let tabelaBaixas = false;
  let tabelaControleItens = false;
  const parametrosOP = await BuscaParametrosOrdemProducao();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas === null || colunas.baixa_consumosConsumos === undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosConsumos: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  };

  if (colunas === null || colunas.baixa_consumosEstRes === undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosEstRes: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  };

  if (colunas === null || colunas.baixa_consumosBaixas === undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosBaixas: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  };

  if (colunas === null || colunas.baixa_consumosControleItens === undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosControleItens: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  };

  ativaNavBar();
  function ativaNavBar() {
    $("divLotes").prop("disabled", filtroAplicado)
    $("divBaixas").prop("disabled", filtroAplicado)
  }

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('BAIXA_CONSUMOS')

    jsonStr.map(async (item) => {
      switch (item.CAMPO) {
        case 'DEPOSITO': {
          insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'CLIENTE': {
          insereValor('#txtCliente', item.VALOR, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: item.VALOR });
          break;
        }
      }
    });
  };

  await carregaValoresPadroes();

  componenteFiltro('deposito', false, false);
  componenteFiltro('qualidade', false, false);
  componenteFiltro('parte', true, true);
  componenteFiltro('aplicacao', true, true);
  componenteFiltro('grupoMA', true, true, 'Grupo');
  componenteFiltro('subGrupo', true, true);
  componenteFiltro('setor', true, true);
  componenteFiltro('tipoMov', false, false, 'TipoBaixa');
  componenteFiltro('cor', false, false, 'CorCI');
  componenteFiltro('deposito', false, false, 'DepositoCI');
  componenteFiltro('aplicacao', false, false, 'AplicacaoCI');
  componenteFiltro('setor', false, false, 'SetorCI');
  componenteFiltro('parte', false, false, 'ParteCI');

  $(`#btnOF`).pesquisa_serverside([`#txtOF`], ["NUMERO"], ["CODIGO"], `{
                "tabela":"OF1", 
                "camposSelectSubSelect": ["CODIGO","CODIGO2", "CODCLI", "NUMERO", "DESCRICAO", "NOME", "CNPJ", "FANTASIA"],
                "camposSelect":[
                    "OF1.CODIGO",
                    "PRODUTO.CODIGO2",
                    "OF1.CODCLI",
                    "OF1.NUMERO",
                    "PRODUTO.DESCRICAO",
                    "ENTIDADE.NOME",
                    "ENTIDADE.CNPJ",
                    "ENTIDADE.FANTASIA"
                ],  
                "groupBySubSelect": ["CODIGO","CODIGO2", "CODCLI", "NUMERO", "DESCRICAO", "NOME", "CNPJ", "FANTASIA"],
                "innerjoin": [
                    {"tabela" : "PRODUTO", "condicao" : "PRODUTO.CODIGO = OF1.CODIGO"},
                    {"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = OF1.CODCLI"}
                ],
                "where": null
            }`, 'Pesquisa de ordem produção');
  $('#btnLimpaOF').on('click', function () { $('#txtOF').val(''); });

  $('#txtCliente').autocompleta(1, `JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ" ], "where": null }`);
  $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ" ], "where": null }`, 'Pesquisa de cliente');
  $('#btnLimpaCliente').on('click', function () { $('#txtCliente').val(''); });

  $('#txtCodigoCI').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO, UNIDADE"], "where": [] }`, ['#txtUnidadeCI'], ['UNIDADE'], ['UNIDADE'], undefined, [true]);
  $('#btnCodigoCI').pesquisa_serverside(['#txtCodigoCI', '#txtUnidadeCI'], ['CODIGO', 'UNIDADE'], ['DESCRICAO', 'UNIDADE'], '{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE" ], "where": null}', 'Pesquisa Material', undefined, [false, true]);
  $('#btnLimpaCodigoCI').on('click', function () {
    $('#txtCodigoCI').val('');
    $('#txtUnidadeCI').val('');
  });

  if (screen.height < 1080) {
    $('#tabControleItens').css('max-height', '250px');
  } else {
    $('#tabControleItens').css('max-height', '400px');
  }

  $('#txtOF, #txtDeposito').on('blur', async function () {
    const numero = pegaChave('#txtOF');
    const deposito = pegaChave('#txtDeposito');
    const qualidade = pegaChave('#txtQualidade');
    const parte = await formataListas($('#txtParte').val().toString());
    const aplicacao = await formataListas($('#txtAplicacao').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());
    try {
      if (numero != '' && deposito != '') {
        $.LoadingOverlay('show');

        $("#btnConfirmarBarra").prop("disabled", false);

        if ($.fn.DataTable.isDataTable('#tabelaConsumos'))
          $("#tabelaConsumos").DataTable().rows().clear().draw(false);

        if ($.fn.DataTable.isDataTable('#tabelaBaixas'))
          $("#tabelaBaixas").DataTable().rows().clear().draw(false);

        if ($.fn.DataTable.isDataTable('#tabelaEstReserva'))
          $("#tabelaEstReserva").DataTable().rows().clear().draw(false);

        await buscaDados(numero, qualidade, deposito, parte, aplicacao, grupo, subgrupo, setor);
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
      ajustaTabelas();
    };
  });

  function ajustaTabelas() {
    if ($.fn.DataTable.isDataTable('#tabelaEstReserva')) {
      $("#tabelaEstReserva").DataTable().columns.adjust().draw(false);
    };
    if ($.fn.DataTable.isDataTable('#tabelaBaixas')) {
      $("#tabelaBaixas").DataTable().columns.adjust().draw(false);
    };
  }

  $("#nav-tab").on("click", function () {
    ajustaTabelas();
  })

  $('#txtParte, #txtAplicacao, #txtGrupo, #txtSubGrupo, #txtSetor').on('change', function () {
    $('#txtOF').trigger('blur');
  })

  async function buscaDados(numero, qualidade, deposito, parte, aplicacao, grupo, subgrupo, setor) {
    let response = await requisicao('GET', '/Sisplan/baixaconsumos/V1/buscadados?', `&NUMERO=${numero}&QUALIDADE=${qualidade}&DEPOSITO=${deposito}&PARTE=${parte}&APLICACAO=${aplicacao}&GRUPO=${grupo}&SUBGRUPO=${subgrupo}&SETOR=${setor}`, null);

    if (!response) {
      return;
    }

    let data = await response.json();
    if (response.status != 200) {
      msgErro(data.mensagem);
    }

    filtroAplicado = true;
    ativaNavBar();

    await criaTabelasTela(data.CONSUMOS, data.ESTOQUE_RESERVA, data.BAIXAS);

    $('#txtPrecoSped').val(data.PRECO_SPED);
    if (data.FINALIZADO) {
      $('#btnGravar').removeClass('d-none');
      $('#btnEstornar').removeClass('d-none');
      $('#btnControleItens').removeClass('d-none');
      $('#btnGravar').prop('disabled', true);
      $('#btnEstornar').prop('disabled', true);
      $('#btnControleItens').prop('disabled', true);
      $('#btnFinalizar').prop('disabled', true);
      $('#btnReabrir').removeClass("d-none");
      msgErro('Baixa de consumos já finalizada para essa OF.');
    } else {
      $('#btnGravar').removeClass('d-none');
      $('#btnEstornar').removeClass('d-none');
      $('#btnControleItens').removeClass('d-none');
      $('#btnGravar').prop('disabled', false);
      $('#btnEstornar').prop('disabled', false);
      $('#btnControleItens').prop('disabled', false);
      $('#btnFinalizar').prop('disabled', false);
      $('#btnReabrir').addClass("d-none");
    }
  }

  $('#txtPrecoSped').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $('#txtRetornoEstoque').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 4,
  });

  function adicionaMascaraCampos() {
    $('.apenasFloat').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 4,
    });

    $('.apenasInteiros').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  $('#formcard1 input').keydown(function (event) {
    if (event.key === 'Enter' || event.keyCode === 13) {
      event.preventDefault()

      const inputs = $('#formcard1 input:visible:enabled')
      const nextInput = inputs.eq(inputs.index(this) + 1)

      if (nextInput.length) {
        if ($($(nextInput[0])[0]).hasClass('select2-search__field')) {
          nextInput.trigger('focusin')
        } else {
          nextInput.focus()
        }
      }
    }
  })

  const cols = [
    { data: 'ID_CONSUMO', title: 'Id' },
    { data: 'CODIGO', title: 'Código' },
    { data: 'DESCRICAO', title: 'Descrição' },
    { data: 'UNIDADE', title: 'Unidade' },
    { data: 'COR', title: 'Cor' },
    { data: 'DESC_COR', title: 'Desc. Cor' },
    { data: 'QTDE', title: 'Qtde' },
    { data: 'CONS_ORIG', title: 'Consumo Original' },
    { data: 'CONSUMO', title: 'Consumo' },
    { data: 'BAIXADO', title: 'Baixado' },
    { data: 'SALDO', title: 'Saldo' },
    { data: 'BAIXAR', title: 'Baixar' },
    { data: 'TOTAL_RESERVA', title: 'Total Reserva' },
    { data: 'ESTOQUE', title: 'Estoque' },
    { data: 'RESERVA', title: 'Reserva' },
    { data: 'APLICACAO', title: 'Aplicação' },
    { data: 'DESC_APLICACAO', title: 'Desc. Aplicação' },
    { data: 'SETOR', title: 'Setor' },
    { data: 'DESC_SETOR', title: 'Desc. Setor' },
    { data: 'DEPOSITO', title: 'Depósito' },
    { data: 'LOTE', title: 'Lote' },
    { data: 'PARTE', title: 'Parte' }
  ];

  function criaTabelaConsumos(info) {
    function carregaInput(valor, indices) {
      return `<input type="text" id="txtBaixar_${indices.row}"
              class="input-default focus form-control apenasFloat text-right classBaixar"
              style="min-width: 15ch; max-width: 20ch" value="${valor}">`;
    }

    if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
      $('#tabelaConsumos').DataTable().destroy();
      $('#tabelaConsumos').empty();
    }

    //#region tabelaConsumos
    $("#tabelaConsumos").DataTable({
      destroy: true,
      filter: true,
      info: true,
      lengthChange: true,
      data: info,
      columns: cols,
      scrollX: true,
      scrollY: '12.5rem',
      pageLength: 10,
      paging: true,
      processing: true,
      autoWidth: true,
      columnDefs: [
        {
          targets: [11],
          render: function (data, type, row, meta) {
            return carregaInput(data, meta);
          }
        },
        {
          targets: [6, 7, 8, 9, 10, 12, 13, 14],
          render: function (data) {
            if (!data) {
              return parseFloat(0).toFixed(4);
            }
            return parseFloat(data).toFixed(4);
          }
        }],
    }).draw(false);

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    $('#tabelaConsumos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaConsumos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show');
      try {
        setarTabelaEdicao("consumos");
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide');
      };
    });

    $('#tabelaConsumos').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.baixa_consumosConsumos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        };
      }
    );

    $('#buttonExcel').on('click', async function () {
      await exportaCSV(null, null, false, null, 'Relatório de Consumos', null, '', 999, false, false, info);
    });

    $('#tabelaConsumos tbody').unbind('click');
    $('#tabelaConsumos tbody').on('click', 'tr', async function (e) {
      if ($('#tabelaConsumos').DataTable().data().length > 0) {
        $('#tabelaConsumos').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        filtraEstReserva($('#tabelaConsumos').DataTable().row($(this)).data());
      }
    });

    $('.classBaixar').on('keydown', async function (e) {
      if (e.which == 13) {
        e.preventDefault();
        $(this).trigger('blur');
      }
    });

    $('.classBaixar').on('blur', async function () {

      const tabelaConsumos = $('#tabelaConsumos').DataTable();
      const tabelaEst = $('#tabelaEstReserva').DataTable();

      const selectedRow = tabelaConsumos.row($('tr.selected'));
      const dataConsumo = selectedRow.data();
      const dataEst = tabelaEst.data().toArray();

      const id_consumo = dataConsumo?.ID_CONSUMO;
      const qtde_baixada = dataConsumo?.BAIXADO;

      let qtde = parseFloat($(this).val()) || 0;

      const atualizarCheckbox = (checked) => {
        const idx = tabelaEst.rows().eq(0).filter(i => tabelaEst.row(i).data().ID_CONSUMO == id_consumo);

        if (!idx.length) return;

        const row = tabelaEst.row(idx[0]);
        const data = row.data();

        data.SEL = checked;
        row.data(data).draw(false);

        $(row.node()).find('#cbSel_0').prop('checked', checked);
      };

      if (qtde <= 0) {
        atualizarCheckbox(false);
        return;
      }

      const registro = dataEst.find(e => e.ID_CONSUMO == id_consumo);

      if (!registro) {
        $(this).val(0);
        return msgAlerta('Não foi encontrado estoque para o item. Impossível continuar.');
      }

      const estoque = parseFloat(registro.QTDE) || 0;

      if (estoque < qtde) {
        $(this).val(0);
        return msgAlerta(`Estoque insuficiente. Disponível: ${estoque}, Solicitado: ${qtde}.`);
      }

      await recalculaQtdeNova(id_consumo, dataEst, qtde, qtde_baixada);
      $(selectedRow.node()).trigger('click');

      atualizarCheckbox(true);

    });
  }

  function filtraEstReserva(data) {
    var tabelaColuna = $('#tabelaEstReserva').DataTable().column(1).search(`^${data.ID_CONSUMO}$|^$`, true, false);
    if (tabelaColuna.length > 0) {
      tabelaColuna.draw(false);
    };
  };

  function criaTabelaEstoqueReserva(info) {
    if ($.fn.DataTable.isDataTable('#tabelaEstReserva')) {
      $('#tabelaEstReserva').DataTable().destroy();
      $('#tabelaEstReserva').empty();
    };

    function retornaBotaoSel(meta, data) {
      let marcado = '';
      if (data.SEL == 'S') {
        marcado = 'checked';
      };

      return `<div class="icheck-primary" style="max-width: 20px">
            <input type="checkbox" ${marcado} id="cbSel_${meta.row}" class="cbSel">
            <label for="cbSel_${meta.row}"></label>
          </div>`
    };

    const cols = [
      { data: 'SEL', title: 'Sel' },
      { data: 'ID_CONSUMO', title: 'Id' },
      { data: 'CODIGO', title: 'Código' },
      { data: 'COR', title: 'Cor' },
      { data: 'DEPOSITO', title: 'Depósito' },
      { data: 'BARRA', title: 'Barra' },
      { data: 'LOTE', title: 'Lote' },
      { data: 'QUALIDADE', title: 'Qualidade' },
      { data: 'QTDE', title: 'Estoque' },
      { data: 'UTILIZADO', title: 'Utilizado' },
      { data: 'RESERV_TOTAL', title: 'Reserva Total' },
      { data: 'RESERVADO', title: 'Reservado' },
      { data: 'SALDO_RESERV', title: 'Disponível' },
      { data: 'CONSUMO', title: 'Consumo' },
      { data: 'SALDO', title: 'Saldo' },
      { data: 'QTDE_B', title: 'Baixar' },
      { data: 'LOCAL', title: 'Local' },
      { data: 'DT_ENTRADA', title: 'Data Entrada' },
      { data: 'OBS', title: 'Obs' }
    ];

    //#region tabelaEstReserva
    $("#tabelaEstReserva").DataTable({
      destroy: true,
      filter: true,
      info: false,
      sort: false,
      lengthChange: true,
      data: info,
      columns: cols,
      scrollX: true,
      scrollY: '12.5rem',
      pageLength: 10,
      paging: true,
      processing: true,
      columnDefs: [
        {
          targets: [1],
          visible: false
        },
        {
          targets: [0],
          render: function (data, type, row, meta) {
            return retornaBotaoSel(meta, row);
          }
        },
        {
          targets: [8, 9, 10, 11, 12, 13, 14, 15],
          render: function (data, type, row, meta) {
            if (!data) {
              return parseFloat(0).toFixed(4);
            }
            return parseFloat(data).toFixed(4)
          }
        },
        {
          targets: [17],
          type: "date-br",
          render(data) {
            if (!data) {
              return '';
            }
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
        }
      ],
      autoWidth: true,
    });

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    $('#tabelaEstReserva').DataTable().columns.adjust().draw(false);

    $('#tabelaEstReserva_length').prepend('<button class="buttonColVis" id="buttonColVisEstReserva"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstReserva_length').prepend('<button class="buttonExcel" id="buttonExcelEstReserva"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisEstReserva').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelEstReserva').prop('title', 'Exportar')

    $('#buttonColVisEstReserva').on('click', async function () {
      $.LoadingOverlay('show');
      try {
        setarTabelaEdicao("estReserva");
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide');
      };
    });

    $('#tabelaEstReserva').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.baixa_consumosEstRes).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        };
      }
    );

    $('#buttonExcelEstReserva').on('click', async function () {
      await exportaCSV(null, null, false, null, 'Relatório Estoque e Reserva', null, '', 999, false, false, info);
    })

    if ($('#tabelaConsumos').DataTable().data().length > 0) {
      $($('#tabelaConsumos tbody tr')[0]).trigger('click');
    }

    adicionaMascaraCampos();
  }

  $('#tabelaEstReserva').on('change', '.cbSel', async function () {
    const row = $('#tabelaConsumos').DataTable().$('tr.selected');
    await recalculaQtdeSel($('#tabelaEstReserva').DataTable().row($(this).parents('tr')).data(),
      $('#tabelaEstReserva').DataTable().data().toArray(),
      this,
      $('#tabelaConsumos').DataTable().row($('tr.selected')).data().BAIXADO);
    $(row).trigger('click');
  });

  async function recalculaQtdeNova(id_consumo, data, qtdeNova, qtdeBaixada) {
    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/recalculaqtdenova?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
      `&DATA=${encodeURIComponent(JSON.stringify(data))}&ID_CONSUMO=${id_consumo}&QTDE_NOVA=${qtdeNova.replace('.', ',')}&QTDE_BAIXADA=${String(qtdeBaixada).replace('.', ',')}`);

    if (!response) {
      return;
    }

    let json = await response.json();
    if (response.status != 200) {
      msgErro(json.mensagem);
      $(instance).prop('checked', false);
      return;
    }

    criaTabelaEstoqueReserva(json);
  }

  async function recalculaQtdeSel(data_selected, data, instance, qtde_bai) {
    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/recalculaqtdesel?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
      `&DATA=${encodeURIComponent(JSON.stringify(data))}&ID_CONSUMO=${data_selected.ID_CONSUMO}&CODIGO=${data_selected.CODIGO}&COR=${data_selected.COR}&LOTE=${data_selected.LOTE}&ACAO=${$(instance).prop('checked')}&QTDE_BAIXADA=${String(qtde_bai).replace('.', ',')}`);

    if (!response) {
      return;
    }

    let json = await response.json();
    if (response.status != 200) {
      msgErro(json.mensagem);
      $(instance).prop('checked', false);
      return;
    }

    criaTabelaEstoqueReserva(json);
  }

  $('#btnFinalizar').on('click', async function (e) {
    e.preventDefault();
    if ($('#txtOF').val() == '') {
      msgErro('OF não informada, impossível continuar.', () => { $('#txtOF').focus() }, () => { $('#txtOF').focus() });
      return;
    }

    if ($('#txtDeposito').val() == '') {
      msgErro('Depósito não informado, impossível continuar.', () => { $('#txtDeposito').focus() }, () => { $('#txtDeposito').focus() });
      return;
    }

    if ($('#txtQualidade').val() == '') {
      msgErro('Qualidade não informada, impossível continuar.', () => { $('#txtQualidade').focus() }, () => { $('#txtQualidade').focus() });
      return;
    }

    msgAlerta('Deseja finalizar a baixa de consumos dessa OF?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await FinalizaBaixa(); } finally { $.LoadingOverlay('hide') } });
  });

  async function FinalizaBaixa() {
    try {
      const obj = {
        NUMERO: pegaChave('#txtOF'),
        DEPOSITO: pegaChave('#txtDeposito'),
        QUALIDADE: pegaChave('#txtQualidade'),
        PRECO_SPED: $('#txtPrecoSped').val(),
        ITENS: $('#tabelaConsumos').DataTable().data().toArray()
      }

      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/finalizabaixa?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&JSON=${encodeURIComponent(JSON.stringify(obj))}`);
      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() { $('#txtOF').trigger('blur') },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível finalizar a baixa de consumos: ${e}`);
    }
  }

  $('#btnReabrir').on('click', async function (e) {
    e.preventDefault();

    if ($('#txtOF').val() == '') {
      msgErro('OF não informada, impossível continuar.', () => { $('#txtOF').focus() }, () => { $('#txtOF').focus() });
      return;
    }

    if ($('#txtDeposito').val() == '') {
      msgErro('Depósito não informado, impossível continuar.', () => { $('#txtDeposito').focus() }, () => { $('#txtDeposito').focus() });
      return;
    }

    if ($('#txtQualidade').val() == '') {
      msgErro('Qualidade não informada, impossível continuar.', () => { $('#txtQualidade').focus() }, () => { $('#txtQualidade').focus() });
      return;
    }

    msgAlerta('Deseja reabrir a baixa de consumos dessa OF?', () => { }, () => { }, async function () { $.LoadingOverlay('show'); try { await ReabreBaixa(); } finally { $.LoadingOverlay('hide') } })
  });

  async function ReabreBaixa() {
    try {
      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/reabrebaixa?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&NUMERO=${pegaChave('#txtOF')}`);
      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() { $('#txtOF').trigger('blur') },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível reabrir a baixa de consumos: ${e}`);
    }
  }

  $('#btnGravar').on('click', async function (e) {
    e.preventDefault();
    try {
      msgAlerta('Deseja gravar os dados?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await gravaBaixaConsumos() } finally { $.LoadingOverlay('hide') } })
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gravar os dados: ${e}`);
    } finally {
    }
  });

  async function gravaBaixaConsumos() {
    function retornaConsumos() {
      return $('#tabelaConsumos').DataTable().data().toArray().map(function (e, i) {
        return {
          ID_CONSUMO: e.ID_CONSUMO,
          CODIGO: e.CODIGO,
          COR: e.COR,
          APLICACAO: e.APLICACAO,
          DEPOSITO: e.DEPOSITO,
          LOTE: e.LOTE,
          BAIXAR: $(`#txtBaixar_${i}`).val(),
          SETOR: e.SETOR,
          PARTE: e.PARTE
        }
      })
    }

    const obj = {
      NUMERO: pegaChave('#txtOF'),
      DEPOSITO: pegaChave('#txtDeposito'),
      QUALIDADE: pegaChave('#txtQualidade'),
      PRECO_SPED: $('#txtPrecoSped').val(),
      CLIENTE: pegaChave('#txtCliente'),
      TIPO_BAIXA: pegaChave('#txtTipoBaixa'),
      MOVIMENTO: $('#txtMovimento').val(),
      ITENS: retornaConsumos(),
      LOTES: $('#tabelaEstReserva').DataTable().data().toArray()
    }

    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/gravadados?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&JSON=${encodeURIComponent(JSON.stringify(obj))}`);
    if (!response) {
      return;
    }

    if (response.status != 200) {
      let json = await response.json();
      msgErro(json.mensagem);
      return;
    }

    toastr.success("Dados gravados com sucesso!", "Confirmação", {
      toastClass: "alert",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      onHidden() { window.location.href = `${BASE_URI}/baixa_consumos` },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });
  }

  function criaTabelaBaixas(info) {
    if ($.fn.DataTable.isDataTable('#tabelaBaixas')) {
      $('#tabelaBaixas').DataTable().destroy();
      $('#tabelaBaixas').empty();
    }

    const cols = [
      { data: 'ID_CONSUMO', title: 'Id' },
      { data: 'ORDEM', title: 'Ordem' },
      { data: 'LANCAMENTO', title: 'Lançamento' },
      { data: 'CODIGO', title: 'Código' },
      { data: 'COR', title: 'Cor' },
      { data: 'DESC_COR', title: 'Desc. Cor' },
      { data: 'DEPOSITO', title: 'Depósito' },
      { data: 'LOTE', title: 'Lote' },
      { data: 'QTDE', title: 'Quantidade' },
      { data: 'DT_MOVTO', title: 'Data Mov' },
      { data: 'PRECO', title: 'Preço' },
      { data: 'ESTOQUE', title: 'Estoque' },
      { data: 'MOV', title: 'Mov' },
      { data: 'DESC_MOV', title: 'Descrição Mov' },
      { data: 'TIPO', title: 'Tipo' },
      { data: 'DESC_TIPO', title: 'Desc. Tipo' },
      { data: 'QUALIDADE', title: 'Qualidade' }
    ];

    //#region tabelaBaixas
    $("#tabelaBaixas").DataTable({
      destroy: true,
      sort: true,
      filter: true,
      info: false,
      lengthChange: true,
      data: info,
      columns: cols,
      scrollX: true,
      scrollY: '12.5rem',
      scrollCollapse: true,
      pageLength: 10,
      paging: true,
      processing: true,
      fixedColumns: {
        leftColumns: 1
      },
      columnDefs: [
        {
          targets: [8, 10, 11],
          className: 'dt-right',
          render: function (data, type, row, meta) {
            if (!data) {
              return parseFloat(0).toFixed(4);
            }
            return parseFloat(data).toFixed(4);
          }
        },
        {
          targets: [10],
          type: "date-br",
          render: function (data) {
            if (!data) return '';
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          }
        },
        {
          targets: '_all',
          defaultContent: ''
        }
      ],
      autoWidth: false,
      initComplete: function () {
        this.api().columns.adjust();
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    $('#tabelaBaixas_length').prepend('<button class="buttonColVis" id="buttonColVisBaixas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaBaixas_length').prepend('<button class="buttonExcel" id="buttonExcelBaixas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisBaixas').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelBaixas').prop('title', 'Exportar')

    $('#buttonColVisBaixas').on('click', async function () {
      $.LoadingOverlay('show');
      try {
        setarTabelaEdicao("baixas");
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide');
      };
    });

    $('#tabelaBaixas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.baixa_consumosBaixas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        };
      }
    );

    $('#buttonExcelBaixas').on('click', async function () {
      await exportaCSV(null, null, false, null, 'Relatório de Baixas', null, '', 999, false, false, info);
    })

    $('#tabelaBaixas tbody').unbind('click');
    $('#tabelaBaixas tbody').on('click', 'tr', async function (e) {
      if ($('#tabelaBaixas').DataTable().data().length > 0) {
        $('#tabelaBaixas').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        filtraEstReserva($('#tabelaBaixas').DataTable().row($(this)).data());
      }
    });
  }

  $('#btnEstornar').on('click', async function (e) {
    e.preventDefault();
    try {
      if ($('#tabelaBaixas').DataTable().data().length == 0) {
        msgErro('Não existem lançamentos. Impossível continuar.');
        return;
      }

      const data = $('#tabelaBaixas').DataTable().row($('tr.selected')).data();
      if (!data) {
        msgErro('Nenhum lançamento selecionado. Impossível continuar.');
        return;
      }

      msgAlerta('Deseja realmente estornar o lançamento selecionado?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await estornaBaixa(data) } finally { $.LoadingOverlay('hide') } });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível realizar o estorno: ${e}`);
    } finally {
    }
  })

  async function estornaBaixa(row) {
    const data = $('#tabelaBaixas').DataTable().data().toArray();
    const numero = pegaChave('#txtOF');
    const deposito = pegaChave('#txtDeposito');
    const qualidade = pegaChave('#txtQualidade');
    const parte = await formataListas($('#txtParte').val().toString());
    const aplicacao = await formataListas($('#txtAplicacao').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());
    if (numero != '' && deposito != '') {

      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/estornabaixa?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
        `&DATA=${encodeURIComponent(JSON.stringify(data))}&ID_CONSUMO=${row.ID_CONSUMO}&LANCAMENTO=${row.LANCAMENTO}&ORDEM=${row.ORDEM}&NUMERO=${numero}&QUALIDADE=${qualidade}&DEPOSITO=${deposito}&PARTE=${parte}&APLICACAO=${aplicacao}&GRUPO=${grupo}&SUBGRUPO=${subgrupo}&SETOR=${setor}`);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      filtroAplicado = true;
      ativaNavBar();

      await criaTabelasTela(json.CONSUMOS, json.ESTOQUE_RESERVA, json.BAIXAS);
      $('#txtPrecoSped').val(json.PRECO_SPED);

      toastr.success("Lançamento estornado com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 800,
        onHidden() {
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } else {
      msgErro('Número e/ou depósito inválido(s). Impossível continuar.');
      return;
    }
  }

  $("#txtBarra").on("blur", function () {
    if ($("#txtBarra").val() !== "") {
      $("#btnConfirmarBarra").prop("disabled", false);
    }
  });

  $('#txtBarra').on('keydown', async function (event) {
    if ((event.key == 'Enter')) {
      $('#btnConfirmarBarra').trigger('click');
    }
  });

  async function validaBarraLida(barra, numero) {
    const existeReserva = (await buscaValorListaWhere('MAT_RESERVA', ['LOTE'], ['LOTE', 'NUMERO'], [`${barra}`, `${numero}`])).LOTE
    const parametroBaixaSemReserva = parametrosOP[4].VALOR
    const msg = `Barra: ${barra} não contém reserva para esta OF!`

    if (!existeReserva) {
      let retorno = false

      switch (parametroBaixaSemReserva) {
        case '0':
          {
            retorno = await new Promise((resolve) => {
              msgAguardaConfirmacao(
                `${msg} \nDeseja continuar?`,
                () => resolve(true),
                () => resolve(false),
              )
            })
          }
          break;
        case '1':
          {
            retorno = await new Promise((resolve) => {
              senhaSupervisor(
                msg,
                () => resolve(true),
                '',
                false,
                () => resolve(false),
                () => resolve(false),
                () => resolve(false),
                false,
                'BAIXA_CONSUMOS'
              )
            })
          }
          break;
        case '2':
          {
            msgAlerta(`${msg} \nImpossível continuar.`)
            retorno = false
          }
          break;
        default:
          break;
      }

      return retorno
    } else {
      return true
    }
  }

  $('#btnConfirmarBarra').on('click', async function (e) {
    e.preventDefault();
    const barra = $('#txtBarra').val();
    if (barra == '') {
      msgErro('Nenhuma barra informada. Impossível continuar.', () => { }, () => { $('#txtBarra').focus() }, () => { $('#txtBarra').focus() });
      return;
    }
    const retornoEstoque = safeParseFloat($('#txtRetornoEstoque').val())
    let equacionarReserva = false
    const dados = { ITENS: retornaConsumos() };
    const deposito = pegaChave('#txtDeposito');
    const cliente = pegaChave('#txtCliente');
    const numero = pegaChave('#txtOF');
    const qualidade = pegaChave('#txtQualidade');
    const tipoBaixa = pegaChave('#txtTipoBaixa');
    const parte = await formataListas($('#txtParte').val().toString());
    const aplicacao = await formataListas($('#txtAplicacao').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());

    if (retornoEstoque > 0) {
      const quantidadeReserva = await retornarQuantidadeReserva(dados, barra, numero, deposito, cliente)
      if (quantidadeReserva > 0) {
        await new Promise((resolve) => {
          msgAlerta(
            'Baixa possui reserva e retorno de estoque, deseja equacionar a reserva?',
            () => null,
            () => {
              resolve()
            },
            () => {
              equacionarReserva = true
              resolve()
            },
            () => {
              resolve()
            },
            true
          )
        })
      }
    }

    $.LoadingOverlay('show');
    try {

      if (await validaBarraLida(barra, numero)) {
        await leBarraConsumo(dados, deposito, cliente, numero, barra, qualidade, tipoBaixa, parte, aplicacao, grupo, subgrupo, setor, retornoEstoque, equacionarReserva);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#txtBarra').val('');
      $('#txtRetornoEstoque').val('');
    }
  })

  async function retornarQuantidadeReserva(dados, barra, numero, deposito, cliente) {
    try {
      const response = await requisicao('POST', `/Sisplan/baixaconsumos/V1/quantidadereserva?`, ``, `DATA=${encodeURIComponent(JSON.stringify(dados))}&BARRA=${barra}&NUMERO=${numero}&DEPOSITO=${deposito}&CLIENTE=${cliente}`, 30000)
      const json = await response.json()

      if (!json) {
        return 0
      }

      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado ?? 0

    } catch (err) {
      console.error(err)
      return 0
    }
  }

  async function leBarraConsumo(dados, deposito, cliente, numero, barra, qualidade, tipoBaixa, parte, aplicacao, grupo, subgrupo, setor, retornoEstoque, equacionarReserva) {
    try {

      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/lebarra?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
        `&DATA=${encodeURIComponent(JSON.stringify(dados))}&NUMERO=${numero}&DEPOSITO=${deposito}&CLIENTE=${cliente}&BARRA=${barra}&QUALIDADE=${qualidade}&TIPO_BAIXA=${tipoBaixa}&PARTE=${parte}&APLICACAO=${aplicacao}&GRUPO=${grupo}&SUBGRUPO=${subgrupo}&SETOR=${setor}&RETORNO_ESTOQUE=${retornoEstoque}&EQUACIONAR_RESERVA=${equacionarReserva}`);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      filtroAplicado = true;
      ativaNavBar();

      await criaTabelasTela(json.CONSUMOS, json.ESTOQUE_RESERVA, json.BAIXAS);

      $('#txtPrecoSped').val(json.PRECO_SPED);

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 800,
        onHidden() {
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível ler a barra: ${e}`, () => { $('#txtBarra').val(''); $('#txtBarra').focus() }, () => { $('#txtBarra').val(''); $('#txtBarra').focus() });
    }
  }

  function retornaConsumos() {
    return $('#tabelaConsumos').DataTable().data().toArray().map(function (e, i) {
      return {
        codigo: e.CODIGO,
        descricao: e.DESCRICAO,
        unidade: e.UNIDADE,
        cor: e.COR,
        descCor: e.DESC_COR,
        quantidade: e.QTDE,
        consumoOriginal: e.CONS_ORIG,
        consumo: e.CONSUMO,
        baixado: e.BAIXADO,
        saldo: e.SALDO,
        baixar: $(`#txtBaixar_${i}`).val(),
        estoque: e.ESTOQUE,
        lote: e.LOTE,
        deposito: e.DEPOSITO,
        reserva: e.RESERVA,
        totalReserva: e.TOTAL_RESERVA,
        codApl: e.APLICACAO,
        descApl: e.DESC_APLICACAO,
        setor: e.SETOR,
        descSetor: e.DESC_SETOR,
        parte: e.PARTE,
        idConsumo: e.ID_CONSUMO
      }
    })
  }

  let tabela_ControleItens_criada = false;
  $('#btnControleItens').on('click', function (e) {
    if (!tabela_ControleItens_criada) {
      e.preventDefault();
      if ($('#txtOF').val() == '') {
        msgErro('OF não informada, impossível continuar.', () => { $('#txtOF').focus() }, () => { $('#txtOF').focus() });
        return;
      }
      criaTabelaControleItens($('#tabelaConsumos').DataTable().data().toArray());
      $('.classCI').prop('disabled', true);

      $('#modal-controle-itens').modal('show');
    };
  });

  function criaTabelaControleItens(info) {

    if ($.fn.DataTable.isDataTable('#tabelaControleItens')) {
      $('#tabelaControleItens').DataTable().destroy();
      $('#tabelaControleItens').empty();
    }

    const cols = [
      { data: 'ID_CONSUMO', title: 'Id' },
      { data: 'CODIGO', title: 'Código' },
      { data: 'DESCRICAO', title: 'Descrição' },
      { data: 'UNIDADE', title: 'Unidade' },
      { data: 'COR', title: 'Cor' },
      { data: 'DESC_COR', title: 'Desc. Cor' },
      { data: 'QTDE', title: 'Qtde' },
      { data: 'CONS_ORIG', title: 'Consumo Original' },
      { data: 'CONSUMO', title: 'Consumo' },
      { data: 'BAIXADO', title: 'Baixado' },
      { data: 'SALDO', title: 'Saldo' },
      { data: 'BAIXAR', title: 'Baixar' },
      { data: 'TOTAL_RESERVA', title: 'Total Reserva' },
      { data: 'ESTOQUE', title: 'Estoque' },
      { data: 'RESERVA', title: 'Reserva' },
      { data: 'APLICACAO', title: 'Aplicação' },
      { data: 'DESC_APLICACAO', title: 'Desc. Aplicação' },
      { data: 'SETOR', title: 'Setor' },
      { data: 'DESC_SETOR', title: 'Desc. Setor' },
      { data: 'DEPOSITO', title: 'Depósito' },
      { data: 'LOTE', title: 'Lote' },
      { data: 'PARTE', title: 'Parte' }
    ];

    //#region tabelaControleItens
    $("#tabelaControleItens").DataTable({
      destroy: true,
      filter: true,
      info: true,
      lengthChange: true,
      data: info,
      columns: cols,
      scrollX: true,
      scrollY: '15rem',
      pageLength: 10,
      paging: true,
      processing: true,
      columnDefs: [
        {
          targets: [6, 7, 8, 9, 10, 11, 12, 13, 14],
          render: function (data) {
            if (!data) {
              return parseFloat(0).toFixed(4);
            }
            return parseFloat(data).toFixed(4);
          }
        }],
      autoWidth: true,
    }).draw(false);

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    $('#tabelaControleItens_length').prepend('<button class="buttonColVis" id="buttonColVisControleItens"><i class="fas fa-cogs"></i></button>');
    $('#tabelaControleItens_length').prepend('<button class="buttonExcel" id="buttonExcelControleItens"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisControleItens').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelControleItens').prop('title', 'Exportar')

    $('#buttonColVisControleItens').on('click', async function () {
      $.LoadingOverlay('show');
      try {
        setarTabelaEdicao("controleItens");
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide');
      };
    });

    $('#tabelaControleItens').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.baixa_consumosControleItens).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        };
      }
    );

    $('#buttonExcelControleItens').on('click', async function () {
      await exportaCSV(null, null, false, null, 'Relatório Controle de Itens', null, '', 999, false, false, info);
    })

    $('#tabelaControleItens tbody').unbind('click');
    $('#tabelaControleItens tbody').on('click', 'tr', async function (e) {
      if ($('#tabelaControleItens').DataTable().data().length > 0) {
        $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        preencheDadosControleItens($('#tabelaControleItens').DataTable().row($('tr.selected')).data());
      }
    });

    if ($('#tabelaControleItens').DataTable().data().length > 0) {
      $($('#tabelaControleItens tr')[1]).trigger('click');
    }

    setTimeout(() => {
      $("#tabelaControleItens").DataTable().columns.adjust().draw(false);
    }, 500)
  }

  function preencheDadosControleItens(data) {
    insereValor('#txtIdCI', data.ID_CONSUMO);
    insereValor('#txtCodigoCI', data.CODIGO, data.DESCRICAO);
    insereValor('#txtCorCI', data.COR, data.DESC_COR);
    insereValor('#txtAplicacaoCI', data.APLICACAO, data.DESC_APLICACAO);
    insereValor('#txtSetorCI', data.SETOR, data.DESC_SETOR);
    insereValor('#txtParteCI', data.PARTE, { tabela: 'TIPO_APL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.PARTE });
    insereValor('#txtUnidadeCI', data.UNIDADE);
    insereValor('#txtConsumoCI', data.CONSUMO);
    insereValor('#txtConsumoOrigCI', data.CONS_ORIG);
    insereValor('#txtBaixadoCI', data.BAIXADO);
    insereValor('#txtConsumoUniCI', '0');
  }

  $('#btnAlterarCI').on('click', function () {
    $('#txtConsumoUniCI').prop('disabled', true);
    habilitaEdicaoCI();
    $('#txtCodigoCI').prop('disabled', true);
    $('#btnCodigoCI').prop('disabled', true);
    $('#btnLimpaCodigoCI').prop('disabled', true);
    $('#txtCorCI').prop('disabled', true);
    $('#btnCorCI').prop('disabled', true);
    $('#btnLimpaCorCI').prop('disabled', true);
  })

  function habilitaEdicaoCI() {
    $('.classCI').prop('disabled', false);
    $('#btnConfirmarCI').removeClass('d-none');
    $('#btnDesistirCI').removeClass('d-none');
    $('#btnIncluirCI').addClass('d-none');
    $('#btnAlterarCI').addClass('d-none');
    $('#btnExcluirCI').addClass('d-none');
  }

  $('#btnDesistirCI').on('click', function () {
    desabilitaEdicaoCI();
    if ($('#tabelaControleItens').DataTable().data().length > 0) {
      $($('#tabelaControleItens tr')[1]).trigger('click');
    }
  })

  function desabilitaEdicaoCI() {
    $('#txtConsumoUniCI').prop('disabled', true);
    $('.classCI').prop('disabled', true);
    $('#btnConfirmarCI').addClass('d-none');
    $('#btnDesistirCI').addClass('d-none');
    $('#btnIncluirCI').removeClass('d-none');
    $('#btnAlterarCI').removeClass('d-none');
    $('#btnExcluirCI').removeClass('d-none');
  }

  $('#btnIncluirCI').on('click', function () {
    $('#txtConsumoUniCI').prop('disabled', false);
    $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
    limpaCamposCI();
    habilitaEdicaoCI();
  })

  function limpaCamposCI() {
    $('#txtIdCI').val('0');
    $('#txtCodigoCI').val('');
    $('#txtCorCI').val('');
    $('#txtDepositoCI').val('');
    $('#txtLoteCI').val('');
    $('#txtAplicacaoCI').val('');
    $('#txtSetorCI').val('');
    $('#txtParteCI').val('');
    $('#txtUnidadeCI').val('');
    $('#txtConsumoCI').val('0');
    $('#txtConsumoOrigCI').val('0');
    $('#txtBaixadoCI').val('0');
    $('#txtConsumoUniCI').val('0');
  }

  $('#btnConfirmarCI').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const obj = {
        NUMERO: pegaChave('#txtOF'),
        ID_CONSUMO: $('#txtIdCI').val(),
        CODIGO: pegaChave('#txtCodigoCI'),
        DESCRICAO: pegaChave('#txtDescricaoCI'),
        UNIDADE: $('#txtUnidade').val(),
        COR: pegaChave('#txtCorCI'),
        DESC_COR: pegaDescricao('#txtCorCI'),
        QTDE: $('#txtConsumoUniCI').val(),
        CONSUMO: $('#txtConsumoCI').val(),
        BAIXADO: $('#txtBaixadoCI').val(),
        CONS_ORIG: $('#txtConsumoOrigCI').val(),
        APLICACAO: pegaChave('#txtAplicacaoCI'),
        DESC_APLICACAO: pegaDescricao('#txtAplicacaoCI'),
        SETOR: pegaChave('#txtSetorCI'),
        DESC_SETOR: pegaDescricao('#txtSetorCI'),
        DEPOSITO: pegaChave('#txtDepositoCI'),
        LOTE: $('#txtLoteCI').val(),
        PARTE: pegaChave('#txtParteCI')
      }

      await insereRegistroControleItens(obj);
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gravar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function insereRegistroControleItens(data) {
    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/controleitens?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
      `&DATA=${encodeURIComponent(JSON.stringify(data))}`);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      let json = await response.json();
      msgErro(json.mensagem);
      return;
    }

    await atualizaDadosControleItens();

    toastr.success("Dados gravados com sucesso!", "Confirmação", {
      toastClass: "alert",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 800,
      fadeOut: 800,
      onHidden() {
        desabilitaEdicaoCI();
      },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });
  }

  $('#btnExcluirCI').on('click', async function () {
    msgAlerta('Deseja realmente excluir esse registro?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await excluirRegistroCI() } finally { $.LoadingOverlay('hide') } });
  })

  async function excluirRegistroCI() {
    try {
      const data = $('#tabelaControleItens').DataTable().row($('tr.selected')).data();

      if (data.length == 0) {
        msgErro('Nenhum registro selecionado. Impossível continuar.');
        return;
      }

      let response = await requisicao("DELETE", `/Sisplan/baixaconsumos/V1/controleitens?&CODUSUARIO=${getCookie('cod_usuario')}`,
        `&NUMERO=${pegaChave('#txtOF')}&CODIGO=${data.CODIGO}&COR=${data.COR}&CONSUMO=${String(data.CONSUMO).replace('.', ',')}&ID_CONSUMO=${data.ID_CONSUMO}&BAIXADO=${String(data.BAIXADO).replace('.', ',')}`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      await atualizaDadosControleItens();

      toastr.success("Registro excluído com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 800,
        onHidden() {
          desabilitaEdicaoCI();
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível excluir o registro: ${e}`);
    }
  }

  async function atualizaDadosControleItens() {
    const numero = pegaChave('#txtOF');
    const deposito = pegaChave('#txtDeposito');
    const qualidade = pegaChave('#txtQualidade');
    const parte = await formataListas($('#txtParte').val().toString());
    const aplicacao = await formataListas($('#txtAplicacao').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());
    try {
      if (numero != '' && deposito != '') {
        $.LoadingOverlay('show');

        await buscaDados(numero, qualidade, deposito, parte, aplicacao, grupo, subgrupo, setor);
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      criaTabelaControleItens($('#tabelaConsumos').DataTable().data().toArray());
      $.LoadingOverlay('hide');
    }
  }

  $('#btnFecharCI').on('click', function () {
    $('#modal-controle-itens').modal('hide');
  })

  $("#tabBaixas").on("click", async function () {
    if (filtroAplicado) {
      await trocaPagina(...telaBaixas)
    } else {
      msgAlerta("Necessário um filtro para prosseguir. Impossível Continuar.");
    };
  });

  $("#tabLotes").on("click", async function () {
    if (filtroAplicado) {
      await trocaPagina(...telaEstRes)
    } else {
      msgAlerta("Necessário um filtro para prosseguir. Impossível Continuar.");
    };
  });

  async function trocaPagina(paginaAtual, menuAtual, botoesAtuais = [], paginaNova, menuNovo, botoesNovos = []) {
    $(paginaAtual).removeClass("show");
    $(paginaAtual).removeClass("active");
    $(menuAtual).removeClass("active");

    $(paginaNova).addClass("show");
    $(paginaNova).addClass("active");
    $(menuNovo).addClass("active");

    if (botoesAtuais.length > 0) {
      for (i = 0; i < botoesNovos.length; i++) {
        $(botoesNovos[i]).addClass("d-none")
      };
    };

    if (botoesNovos.length > 0) {
      for (i = 0; i < botoesNovos.length; i++) {
        $(botoesNovos[i]).removeClass("d-none")
      };
    };
  };

  function setarTabelaEdicao(tabela) {
    tabelaConsumos = false;
    tabelaEstRes = false;
    tabelaBaixas = false;
    tabelaControleItens = false;

    if (tabela === "consumos") {
      tabelaConsumos = true;
    } else if (tabela === "estReserva") {
      tabelaEstRes = true;
    } else if (tabela === "baixas") {
      tabelaBaixas = true;
    } else if (tabela === "controleItens") {
      tabelaControleItens = true;
    };
  };

  function validaNovasColunas(novasColunas) {
    if (novasColunas.includes('SEL')) {
      throw new Error('Impossível deixar a coluna SEL invisível, favor desmarcar!');
    };
  };

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const novasColunas = retornaNovasColunasInvisiveis();

      validaNovasColunas(novasColunas);

      if (tabelaConsumos) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosConsumos: novasColunas }))
        $('#tabelaConsumos').DataTable().columns().visible(true);
        $('#tabelaConsumos').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      } else if (tabelaEstRes) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosEstRes: novasColunas }))
        $('#tabelaEstReserva').DataTable().columns().visible(true);
        $('#tabelaEstReserva').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      } else if (tabelaBaixas) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosBaixas: novasColunas }))
        $('#tabelaBaixas').DataTable().columns().visible(true);
        $('#tabelaBaixas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      } else if (tabelaControleItens) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, baixa_consumosControleItens: novasColunas }))
        $('#tabelaControleItens').DataTable().columns().visible(true);
        $('#tabelaControleItens').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      };
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    };
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    const tabela = tabelaConsumos ? "#tabelaConsumos" : tabelaEstRes ? "#tabelaEstReserva" : tabelaBaixas ? "#tabelaBaixas" : tabelaControleItens ? "#tabelaControleItens" : "";

    $(tabela).DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    if (tabelaConsumos) {
      adicionaColunas(cols, colunasInvisiveis.baixa_consumosConsumos ?? []);
    } else if (tabelaEstRes) {
      adicionaColunas(cols, colunasInvisiveis.baixa_consumosEstRes ?? []);
    } else if (tabelaBaixas) {
      adicionaColunas(cols, colunasInvisiveis.baixa_consumosBaixas ?? []);
    } else if (tabelaControleItens) {
      adicionaColunas(cols, colunasInvisiveis.baixa_consumosControleItens ?? []);
    };
  });

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    tabelaConsumos = false;
    tabelaEstRes = false;
    tabelaBaixas = false;
    tabelaControleItens = false;
  });

  const telaBaixas = [
    "#divLotes",
    "#tabLotes",
    ["#divBotoesEstRes", "#btnGravar", "#btnControleItens", "#btnFinalizar"],
    "#divBaixas",
    "#tabBaixas",
    ["#divBotoesBaixa"]
  ];

  const telaEstRes = [
    "#divBaixas",
    "#tabBaixas",
    ["#divBotoesBaixa"],
    "#divLotes",
    "#tabLotes",
    ["#divBotoesEstRes", "#btnGravar", "#btnControleItens", "#btnFinalizar"]
  ];

  async function criaTabelasTela(consumos = [], estoque_reserva = [], baixas = []) {
    try {
      if (consumos.length > 0) {
        criaTabelaConsumos(consumos);
      } else {
        throw new Error("Não existem consumos para esta OF.")
      };

      if (estoque_reserva.length > 0 || baixas.length > 0) {
        $("#btnEstornar").prop("disabled", false);
        try {
          await trocaPagina(...telaEstRes);
          criaTabelaEstoqueReserva(estoque_reserva);
        } catch (error) {
          throw new Error(`Não foi possível criar a tabela Estoque Reserva.`);
        };

        try {
          await trocaPagina(...telaBaixas);
          criaTabelaBaixas(baixas);

          if (baixas.length < 1) {
            $("#btnEstornar").prop("disabled", true);
          };
        } catch (error) {
          throw new Error(`Não foi possível criar a tabela Baixas.`);
        };

        await trocaPagina(...telaEstRes);
      } else {
        throw new Error("Não existem registros de Baixas nem Estoque/Reserva para essa OF.");
      };
    } catch (error) {
      msgAlerta(error.message || "Não foi possivel encontrar os dados da baixa.");
    }
  };
});