$(document).ready(async function () {
    const documentURL = $(document)[0].URL;

    $("#modalConsultaReceita").on("shown.bs.modal", async function () {
        $.LoadingOverlay("show");
        try {
            const relClienteSemAtt = documentURL.indexOf("/relclientesematualizacao") != -1

            if (relClienteSemAtt) {
                $('#btnImportarConsulta').addClass('d-none')
                $('#btnGravarConsulta').removeClass('d-none')
            } else {
                $('#btnImportarConsulta').removeClass('d-none')
                $('#btnGravarConsulta').addClass('d-none')
            }

            const cnpj = $("#txtCNPJConsulta").val();
            await consultaReceita(cnpj);
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#modalConsultaReceita").on("hidden.bs.modal", function () {
        limpaCamposConsultaReceita();
    })

    $("#btnConsultarReceita").on('click', async function () {
        if ($('#txtCNPJConsulta').val() == '' && $('#txtCaptcha').val() == '' || $('#txtCaptcha').val() == '' || $('#txtCNPJConsulta').val() == '') {
            await msgAlerta('Para realizar a consulta é necessário preencher o CNPJ e o Captcha!');
            return;
        }

        let consultaReceita;

        if (usaCertificadoA3 == '1') {
            consultaReceita = await retornaConsultaWWW($('#txtCNPJConsulta').val(), $('#txtCaptcha').val(), jsonCaptcha, $('#txtUF').val(), usaCertificadoA3);
        } else {
            consultaReceita = await retornaConsultaWWW($('#txtCNPJConsulta').val(), $('#txtCaptcha').val(), jsonCaptcha, $('#txtUF').val());
        }

        $('#txtRazaoSocialConsulta').val(consultaReceita.NOME);
        $('#txtFantasiaConsulta').val(consultaReceita.FANTASIA);
        $('#txtDataAbertuta').val(consultaReceita.DT_NASC.slice(0, 10));
        $('#txtRuaConsulta').val(consultaReceita.ENDERECO);
        $('#txtBairroConsulta').val(consultaReceita.BAIRRO);
        $('#txtNumeroConsulta').val(consultaReceita.NUMERO);
        $('#txtCEPConsulta').val(consultaReceita.CEP);
        $('#txtComplementoConsulta').val(consultaReceita.COMPLEMENTO);
        $('#txtSituacaoCadastralConsulta').val(consultaReceita.SIT_CLI);
        $('#txtDataSituacaoConsulta').val(consultaReceita.DATA_CAD.slice(0, 10));
        $('#txtIEConsulta').val(consultaReceita.INSCRICAO);

        await BuscaECadastraCep($("#txtCEPConsulta"));
        let retorno = await BuscaCep($("#txtCEPConsulta"));

        $("#txtMunicipioConsulta").val(retorno[0]);
        $("#txtUFConsulta").val(retorno[1]);

    });

    $("#btnImportarConsulta").on('click', function () {
        const idCNPJ = documentURL.indexOf("/cliente") != -1 ? "txtCNPJ" : "txtCNPJModalCli";

        $(`#${idCNPJ}`).val(formata_cpf_cnpj($("#txtCNPJConsulta").val()));
        $('#txtNome').val($('#txtRazaoSocialConsulta').val());
        $('#txtFantasia').val($('#txtFantasiaConsulta').val());
        $('#txtDataNascimento').val($('#txtDataAbertuta').val());
        $('#txtRua').val($('#txtRuaConsulta').val());
        $('#txtBairro').val($('#txtBairroConsulta').val());
        $('#txtNumero').val($('#txtNumeroConsulta').val());
        $('#txtCidade').val($('#txtMunicipioConsulta').val());
        $('#txtUF').val($('#txtUFConsulta').val());
        $('#txtCep').val($('#txtCEPConsulta').val());
        $('#txtComplemento').val($('#txtComplementoConsulta').val());
        $('#txtIE').val($('#txtIEConsulta').val());
        const codigoCnae = $('#txtCodigoCnaeConsulta').val()
        const descricaoCnae = $('#txtDescricaoCnaeConsulta').val()
        gravarCnae(codigoCnae, descricaoCnae)
        insereValor('#txtCnae', codigoCnae, descricaoCnae)

        if (($('#txtIEConsulta').val() != '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CNPJ')) {
            $('#rgIE').val(1);
        } else if (($('#txtIEConsulta').val() == '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CNPJ')) {
            $('#rgIE').val(2);
        } else if (($('#txtIEConsulta').val() == '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CPF')) {
            $('#rgIE').val(3);
        } else if (($('#txtIEConsulta').val() != '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CPF')) {
            $('#rgIE').val(1);
        }

        $(`#${idCNPJ}`).prop('disabled', true);
        limpaCamposConsultaReceita();
        $("#modalConsultaReceita").modal("hide");
    });

    $("#btnReconsultar").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            const cnpj = $("#txtCNPJConsulta").val();
            await consultaReceita(cnpj);
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    function limpaCamposConsultaReceita() {
        $('#txtCNPJConsulta').val('');
        $('#txtCaptcha').val('');
        $('#txtRazaoSocialConsulta').val('');
        $('#txtFantasiaConsulta').val('');
        $('#txtDataAbertuta').val('');
        $('#txtRuaConsulta').val('');
        $('#txtBairroConsulta').val('');
        $('#txtNumeroConsulta').val('');
        $('#txtMunicipioConsulta').val('');
        $('#txtUFConsulta').val('');
        $('#txtCEPConsulta').val('');
        $('#txtComplementoConsulta').val('');
        $('#txtSituacaoCadastralConsulta').val('');
        $('#txtDataSituacaoConsulta').val('');
        $('#txtIEConsulta').val('');
        $("#txtCodigoCnaeConsulta").val("");
        $("#txtDescricaoCnaeConsulta").val("");
    }

    async function gravarCnae(codigo, descricao) {
        try {
            const objetoCnae = { codigo, descricao }
            const response = await requisicao('POST', '/sisplan/cliente/v1/gravarcnae?', '', JSON.stringify(objetoCnae), 3600000)
            const json = await response.json()

            if (json) {
                const { mensagem } = json
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }
            }
        } catch (e) {
            console.error(e)
        } finally { }
    }

    function preencheCamposReceitaFederal(objReceitaFederal) {
        $('#txtRazaoSocialConsulta').val(objReceitaFederal.nomeEmpresa);
        $('#txtFantasiaConsulta').val(objReceitaFederal.nomeFantasia);
        $('#txtDataAbertuta').val(formataDataComTraco(objReceitaFederal.dataAbertura));
        $('#txtRuaConsulta').val(objReceitaFederal.rua);
        $('#txtBairroConsulta').val(objReceitaFederal.bairro);
        $('#txtNumeroConsulta').val(objReceitaFederal.numeroEndereco);
        $("#txtMunicipioConsulta").val(objReceitaFederal.cidade);
        $("#txtUFConsulta").val(objReceitaFederal.uF);
        $('#txtCEPConsulta').val(objReceitaFederal.cEP);
        $('#txtComplementoConsulta').val(objReceitaFederal.complemento);
        $('#txtSituacaoCadastralConsulta').val(objReceitaFederal.situacaoCadastral);
        $('#txtDataSituacaoConsulta').val(formataDataComTraco(objReceitaFederal.dataSituacaoCadastral));
        $('#txtIEConsulta').val(objReceitaFederal.iE);
        const codigoCnae = objReceitaFederal?.cNAE?.replace(/[^0-9]/g, '')?.substring(0, 7) ?? ''
        const descricaoCnae = objReceitaFederal?.cNAE?.substring(13, 200) ?? ''
        $('#txtCodigoCnaeConsulta').val(codigoCnae)
        $('#txtDescricaoCnaeConsulta').val(descricaoCnae)
    }

    async function consultaReceita(cnpj) {
        try {

            if (cnpj == "") {
                throw new Error("Necessário informar um CNPJ!");
            }

            if (!await testeConexaoApiLocal()) {
                throw new Error("Não foi possível comunicar com a ApiLocal, agora a consulta na Receita Federal necessita desse recurso, entre em contato com o Suporte da Sisplan.");
            }

            let response = await requisicao('GET',
                '/Sisplan/Funcoes/V1/pesquisa?',
                `JSON={ "tabela":"EMPRESA", 
                        "camposSelect":["EMP_ESTADO", "EMP_CSRT", "EMP_CSRT_ID", "EMP_PAT", "EMP_CERT", "EMP_CNPJ", "EMP_ID"], 
                        "where": ["EMP_PAT = '${getCookie('empresa')}'"]
                    }`, null);

            if (!response) {
                throw new Error("Não foi possível consultar o CNPJ na Receita Federal.");
            }

            const jsonStr = await response.json();
            if (response.status !== 200) {
                throw new Error(jsonStr.RESULT[0].mensagem);
            }

            let infoEmp = jsonStr.RESULT[0][0];

            let emp = {
                emp_estado: infoEmp.EMP_ESTADO,
                emp_csrt: infoEmp.EMP_CSRT,
                emp_csrt_id: infoEmp.EMP_CSRT_ID,
                emp_pat: infoEmp.EMP_PAT,
                emp_cert: infoEmp.EMP_CERT,
                emp_cnpj: infoEmp.EMP_CNPJ,
                emp_id: infoEmp.EMP_ID
            };

            response = await requisicao_ecf('GET', '/receitafederal/consultareceitafederal?', `CNPJ=${cnpj}&EMP_CERT=${encodeURIComponent(JSON.stringify(emp))}`, '', 900000);

            if (!response) {
                throw new Error("Não foi possível consultar o CNPJ na Receita Federal.");
            }

            if (response.status != 200) {
                const mensagemErro = await response.text();
                throw new Error(mensagemErro);
            }

            const json = await response.json();
            
            preencheCamposReceitaFederal(json);

            if (json.iE == '') {
                throw new Error("Não foi possível consultar a Inscrição Estadual ou CNPJ não é contribuinte.");
            }

        } catch (error) {
            console.error(error);
            msgAlerta(error.message);
        }
    }


    $('#btnGravarConsulta').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await gravarClienteConsultado()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function gravarClienteConsultado() {
        const codigoCnae = $('#txtCodigoCnaeConsulta').val()
        const descricaoCnae = $('#txtDescricaoCnaeConsulta').val()
        await gravarCnae(codigoCnae, descricaoCnae)
        
        const entidade = {};

        entidade.CODCLI = $('#txtCodCliConsulta').val();
        entidade.CNPJ = formata_cpf_cnpj($("#txtCNPJConsulta").val())
        entidade.NOME = $('#txtRazaoSocialConsulta').val();
        entidade.FANTASIA = $('#txtFantasiaConsulta').val();
        entidade.DT_NASC = $('#txtDataAbertuta').val();
        entidade.ENDERECO = $('#txtRuaConsulta').val()
        entidade.NUMERO = $('#txtNumeroConsulta').val()
        entidade.COMPLEMENTO = $('#txtComplementoConsulta').val()
        entidade.BAIRRO = $('#txtBairroConsulta').val()
        entidade.CEP = $('#txtCEPConsulta').val().replace(/\D/g, "");
        entidade.INSCRICAO = $('#txtIEConsulta').val()
        entidade.DATA_BUSCA = `${new Date().toJSON().slice(0, 10)}T00:00:00Z`;
        entidade.STATUS = (await buscaValor('ENTIDADE', 'STATUS', 'CODCLI', $('#txtCodCliConsulta').val())).STATUS

        if (($('#txtIEConsulta').val() != '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CNPJ')) {
            entidade.IE_DESTINATARIO = 1;
        } else if (($('#txtIEConsulta').val() == '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CNPJ')) {
            entidade.IE_DESTINATARIO = 2;
        } else if (($('#txtIEConsulta').val() == '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CPF')) {
            entidade.IE_DESTINATARIO = 3;
        } else if (($('#txtIEConsulta').val() != '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CPF')) {
            entidade.IE_DESTINATARIO = 1;
        }

        const header = `CODUSUARIO=${getCookie('cod_usuario')}`;

        const body = `JSON=${JSON.stringify(entidade)}`;

        let response = await requisicao("PUT", `/Sisplan/Cliente/V1/salvarclientereceitafederal?`, header, body);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgAlerta(jsonStr.mensagem);
            return;
        }

        criaMensagemSucesso('Cliente Atualizado com sucesso!', () => {$("#modalConsultaReceita").modal("hide");})
    }

})